/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.InputStream;

public class StandardColorSpaces {
    private static ICC_ColorSpace a98rgb;
    private static ICC_ColorSpace prophotoRGB;
    private static ICC_ColorSpace displayP3;
    private static ICC_ColorSpace rec2020;
    private static ICC_ColorSpace xyzD65;

    StandardColorSpaces() {
    }

    public static ICC_ColorSpace getA98RGB() {
        if (a98rgb == null) {
            a98rgb = StandardColorSpaces.loadColorSpace("profiles/A98RGBCompat-v4.icc");
        }
        return a98rgb;
    }

    public static ICC_ColorSpace getProphotoRGB() {
        if (prophotoRGB == null) {
            prophotoRGB = StandardColorSpaces.loadColorSpace("profiles/WideGamutPhoto-v4.icc");
        }
        return prophotoRGB;
    }

    public static ICC_ColorSpace getDisplayP3() {
        if (displayP3 == null) {
            displayP3 = StandardColorSpaces.loadColorSpace("profiles/Display P3.icc");
        }
        return displayP3;
    }

    public static ICC_ColorSpace getRec2020() {
        if (rec2020 == null) {
            rec2020 = StandardColorSpaces.loadColorSpace("profiles/ITU-R_BT2020.icc");
        }
        return rec2020;
    }

    public static ICC_ColorSpace getXYZ_D65() {
        if (xyzD65 == null) {
            xyzD65 = StandardColorSpaces.loadColorSpace("profiles/D65_XYZ.icc");
        }
        return xyzD65;
    }

    private static ICC_ColorSpace loadColorSpace(String string) {
        ICC_Profile iCC_Profile;
        try (InputStream inputStream = StandardColorSpaces.class.getResourceAsStream(string);){
            iCC_Profile = ICC_Profile.getInstance(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return new ICC_ColorSpace(iCC_Profile);
    }

    public static ColorSpace mergeColorSpace(ColorSpace colorSpace, ColorSpace colorSpace2) {
        ColorSpace colorSpace3;
        if (colorSpace == colorSpace2 || colorSpace2 == null || colorSpace2.isCS_sRGB() || colorSpace2 == (colorSpace3 = ColorSpace.getInstance(1004))) {
            return colorSpace;
        }
        if (colorSpace == null || colorSpace.isCS_sRGB() || colorSpace == colorSpace3) {
            return colorSpace2;
        }
        ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getProphotoRGB();
        if (colorSpace == iCC_ColorSpace || colorSpace2 == iCC_ColorSpace) {
            return iCC_ColorSpace;
        }
        return StandardColorSpaces.getRec2020();
    }

    public static ColorSpace mergeColorSpace(ColorSpace colorSpace, ColorSpace colorSpace2, Color color) {
        if (colorSpace == null) {
            if (StandardColorSpaces.isInGamut(color, ColorSpace.getInstance(1000)) || colorSpace2.isCS_sRGB() || colorSpace2 == ColorSpace.getInstance(1004)) {
                return null;
            }
            return colorSpace2;
        }
        if (colorSpace2 == StandardColorSpaces.getProphotoRGB()) {
            return colorSpace2;
        }
        if (colorSpace == StandardColorSpaces.getProphotoRGB() || StandardColorSpaces.isInGamut(color, colorSpace)) {
            return colorSpace;
        }
        ICC_ColorSpace iCC_ColorSpace = StandardColorSpaces.getRec2020();
        if (colorSpace != iCC_ColorSpace && StandardColorSpaces.isInGamut(color, iCC_ColorSpace)) {
            return iCC_ColorSpace;
        }
        return StandardColorSpaces.getProphotoRGB();
    }

    public static ColorSpace containerRGBSpace(Color color, ColorSpace colorSpace) {
        ColorSpace colorSpace2 = ColorSpace.getInstance(1000);
        if (StandardColorSpaces.isInGamut(color, colorSpace2)) {
            return null;
        }
        if (colorSpace != null && StandardColorSpaces.isInGamut(color, colorSpace)) {
            return colorSpace;
        }
        colorSpace2 = StandardColorSpaces.getDisplayP3();
        if (colorSpace != colorSpace2 && StandardColorSpaces.isInGamut(color, colorSpace2)) {
            return colorSpace2;
        }
        colorSpace2 = StandardColorSpaces.getA98RGB();
        if (colorSpace != colorSpace2 && StandardColorSpaces.isInGamut(color, colorSpace2)) {
            return colorSpace2;
        }
        colorSpace2 = StandardColorSpaces.getRec2020();
        if (colorSpace != colorSpace2 && StandardColorSpaces.isInGamut(color, colorSpace2)) {
            return colorSpace2;
        }
        return StandardColorSpaces.getProphotoRGB();
    }

    private static boolean isInGamut(Color color, ColorSpace colorSpace) {
        float[] fArray = color.getColorComponents(colorSpace, null);
        float f = colorSpace.getMinValue(0);
        float f2 = colorSpace.getMaxValue(0);
        for (float f3 : fArray) {
            if (!(f3 <= f) && !(f3 >= f2)) continue;
            return false;
        }
        return true;
    }
}

