/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.virtual;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

public class VirtualAttributeDeleteAction
extends Action {
    private ResultSetViewer resultSetViewer;
    private DBDAttributeBinding attr;

    public VirtualAttributeDeleteAction(ResultSetViewer resultSetViewer, DBDAttributeBinding attr) {
        super("Delete virtual column '" + attr.getName() + "'");
        this.resultSetViewer = resultSetViewer;
        this.attr = attr;
    }

    public boolean isEnabled() {
        return this.attr instanceof DBDAttributeBindingCustom;
    }

    public void run() {
        if (!(this.attr instanceof DBDAttributeBindingCustom)) {
            return;
        }
        DBVEntityAttribute vAttr = ((DBDAttributeBindingCustom)this.attr).getEntityAttribute();
        if (!UIUtils.confirmAction((Shell)this.resultSetViewer.getControl().getShell(), (String)("Delete column '" + vAttr.getName() + "'"), (String)("Are you sure you want to delete virtual column '" + vAttr.getName() + "'?"))) {
            return;
        }
        DBVEntity vEntity = this.resultSetViewer.getModel().getVirtualEntity(false);
        vEntity.removeVirtualAttribute(vAttr);
        vEntity.persistConfiguration();
        this.resultSetViewer.refreshMetaData();
    }
}

