/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.LibraryDef;

public class NativeLibraryLocator {
    private final File extractDir;
    private final String version;

    public NativeLibraryLocator(File extractDir, String version) {
        this.extractDir = extractDir;
        this.version = version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public File find(LibraryDef libraryDef) throws IOException {
        String resourceName = String.format("net/rubygrapefruit/platform/%s/%s", libraryDef.platform, libraryDef.name);
        File libFile = new File(this.extractDir, String.format("%s/%s/%s", this.version, libraryDef.platform, libraryDef.name));
        File lockFile = new File(libFile.getParentFile(), libFile.getName() + ".lock");
        lockFile.getParentFile().mkdirs();
        lockFile.createNewFile();
        try (RandomAccessFile lockFileAccess = new RandomAccessFile(lockFile, "rw");){
            FileLock lock = lockFileAccess.getChannel().lock();
            if (lockFile.length() > 0L && lockFileAccess.readBoolean()) {
                File file = libFile;
                return file;
            }
            URL resource = this.getClass().getClassLoader().getResource(resourceName);
            if (resource != null) {
                libFile.getParentFile().mkdirs();
                NativeLibraryLocator.copy(resource, libFile);
                lockFileAccess.seek(0L);
                lockFileAccess.writeBoolean(true);
                File file = libFile;
                return file;
            }
            File file = null;
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL source, File dest) {
        try (InputStream inputStream = source.openStream();
             FileOutputStream outputStream = new FileOutputStream(dest);){
            int nread;
            byte[] buffer = new byte[4096];
            while ((nread = inputStream.read(buffer)) >= 0) {
                ((OutputStream)outputStream).write(buffer, 0, nread);
            }
        }
        catch (IOException e) {
            throw new NativeException("Could not extract native JNI library.", e);
        }
    }
}

