﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/lexv2-models/model/SlotSortAttribute.h>
#include <aws/lexv2-models/model/SortOrder.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace LexModelsV2 {
namespace Model {

/**
 * <p>Specifies attributes for sorting a list of bots.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/SlotSortBy">AWS
 * API Reference</a></p>
 */
class SlotSortBy {
 public:
  AWS_LEXMODELSV2_API SlotSortBy() = default;
  AWS_LEXMODELSV2_API SlotSortBy(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API SlotSortBy& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The attribute to use to sort the list.</p>
   */
  inline SlotSortAttribute GetAttribute() const { return m_attribute; }
  inline bool AttributeHasBeenSet() const { return m_attributeHasBeenSet; }
  inline void SetAttribute(SlotSortAttribute value) {
    m_attributeHasBeenSet = true;
    m_attribute = value;
  }
  inline SlotSortBy& WithAttribute(SlotSortAttribute value) {
    SetAttribute(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The order to sort the list. You can choose ascending or descending.</p>
   */
  inline SortOrder GetOrder() const { return m_order; }
  inline bool OrderHasBeenSet() const { return m_orderHasBeenSet; }
  inline void SetOrder(SortOrder value) {
    m_orderHasBeenSet = true;
    m_order = value;
  }
  inline SlotSortBy& WithOrder(SortOrder value) {
    SetOrder(value);
    return *this;
  }
  ///@}
 private:
  SlotSortAttribute m_attribute{SlotSortAttribute::NOT_SET};
  bool m_attributeHasBeenSet = false;

  SortOrder m_order{SortOrder::NOT_SET};
  bool m_orderHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
