﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/geo-routes/GeoRoutes_EXPORTS.h>
#include <aws/geo-routes/model/LocalizedString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace GeoRoutes {
namespace Model {

/**
 * <p>Details related to the continue step.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/geo-routes-2020-11-19/RouteContinueStepDetails">AWS
 * API Reference</a></p>
 */
class RouteContinueStepDetails {
 public:
  AWS_GEOROUTES_API RouteContinueStepDetails() = default;
  AWS_GEOROUTES_API RouteContinueStepDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API RouteContinueStepDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_GEOROUTES_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Name of the intersection, if applicable to the step.</p>
   */
  inline const Aws::Vector<LocalizedString>& GetIntersection() const { return m_intersection; }
  inline bool IntersectionHasBeenSet() const { return m_intersectionHasBeenSet; }
  template <typename IntersectionT = Aws::Vector<LocalizedString>>
  void SetIntersection(IntersectionT&& value) {
    m_intersectionHasBeenSet = true;
    m_intersection = std::forward<IntersectionT>(value);
  }
  template <typename IntersectionT = Aws::Vector<LocalizedString>>
  RouteContinueStepDetails& WithIntersection(IntersectionT&& value) {
    SetIntersection(std::forward<IntersectionT>(value));
    return *this;
  }
  template <typename IntersectionT = LocalizedString>
  RouteContinueStepDetails& AddIntersection(IntersectionT&& value) {
    m_intersectionHasBeenSet = true;
    m_intersection.emplace_back(std::forward<IntersectionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<LocalizedString> m_intersection;
  bool m_intersectionHasBeenSet = false;
};

}  // namespace Model
}  // namespace GeoRoutes
}  // namespace Aws
