
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *      Declares the attribute specified by local name and namespace URI to be of type ID. If the value of the 
 *      specified attribute is unique then this element node can later be retrieved using getElementById on Document. 
 *      Note, however, that this simply affects this node and does not change any grammar that may be in use. 
 *      
 *      Set the noNamespaceSchemaLocation attribute on the first acronym element to "No".  Invoke setIdAttributeNS on the 
 *      noNamespaceSchemaLocation attribute of the first, second and third acronym element.  Verify by calling isId on 
 *      the attributes.  Calling getElementById with "No" as a value should return the acronym element.  
 *     
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNS">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNS</a>
*/
public final class elementsetidattributens12 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattributens12(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList;
      Element acronymElem1;
      Element acronymElem2;
      Element acronymElem3;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", false);
      elemList = doc.getElementsByTagNameNS("*", "acronym");
      acronymElem1 = (Element) elemList.item(0);
      acronymElem2 = (Element) elemList.item(1);
      acronymElem3 = (Element) elemList.item(2);
      acronymElem1.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "No");
      acronymElem1.setIdAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", true);
      acronymElem2.setIdAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", true);
      acronymElem3.setIdAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", true);
      attributesMap = acronymElem1.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("xsi:noNamespaceSchemaLocation");
      id = attr.isId();
      assertTrue("elementsetidattributensIsId1True12", id);
      attributesMap = acronymElem2.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("xsi:noNamespaceSchemaLocation");
      id = attr.isId();
      assertTrue("elementsetidattributensIsId2True12", id);
      attributesMap = acronymElem3.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("xsi:noNamespaceSchemaLocation");
      id = attr.isId();
      assertTrue("elementsetidattributensIsId3True12", id);
      elem = doc.getElementById("No");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributensGetElementById10", "acronym", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattributens12";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattributens12.class, args);
   }
}

