/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import org.apache.wicket.protocol.http.AbstractRequestLogger;
import org.apache.wicket.protocol.http.IRequestLogger;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestLogger
extends AbstractRequestLogger {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLogger.class);

    @Override
    protected void log(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        if (LOG.isInfoEnabled()) {
            LOG.info(this.createRequestData(rd, sd));
        }
    }

    private String createRequestData(IRequestLogger.RequestData rd, IRequestLogger.SessionData sd) {
        StringBuilder sb = new StringBuilder(768);
        sb.append("startTime=\"");
        sb.append(this.formatDate(rd.getStartDate()));
        sb.append("\",duration=");
        sb.append(rd.getTimeTaken());
        sb.append(",url=\"");
        sb.append(rd.getRequestedUrl());
        sb.append('\"');
        sb.append(",event={");
        this.appendRequestHandlerString(sb, rd.getEventTarget());
        sb.append("},response={");
        this.appendRequestHandlerString(sb, rd.getResponseTarget());
        sb.append("},sessionid=\"");
        sb.append(rd.getSessionId());
        sb.append('\"');
        sb.append(",sessionsize=");
        sb.append(rd.getSessionSize());
        if (rd.getSessionInfo() != null && !Strings.isEmpty(rd.getSessionInfo().toString())) {
            sb.append(",sessioninfo={");
            sb.append(rd.getSessionInfo());
            sb.append('}');
        }
        if (sd != null) {
            sb.append(",sessionstart=\"");
            sb.append(this.formatDate(sd.getStartDate()));
            sb.append("\",requests=");
            sb.append(sd.getNumberOfRequests());
            sb.append(",totaltime=");
            sb.append(sd.getTotalTimeTaken());
        }
        sb.append(",activerequests=");
        sb.append(rd.getActiveRequest());
        Runtime runtime = Runtime.getRuntime();
        long max = runtime.maxMemory() / 1000000L;
        long total = runtime.totalMemory() / 1000000L;
        long used = total - runtime.freeMemory() / 1000000L;
        sb.append(",maxmem=");
        sb.append(max);
        sb.append("M,total=");
        sb.append(total);
        sb.append("M,used=");
        sb.append(used);
        sb.append('M');
        return sb.toString();
    }

    private void appendRequestHandlerString(StringBuilder sb, IRequestHandler handler) {
        if (handler != null) {
            Class<?> handlerClass = handler.getClass();
            sb.append("handler=");
            sb.append(handlerClass.isAnonymousClass() ? handlerClass.getName() : Classes.simpleName(handlerClass));
            if (handler instanceof ILoggableRequestHandler) {
                sb.append(",data=");
                sb.append(((ILoggableRequestHandler)handler).getLogData());
            }
        } else {
            sb.append("none");
        }
    }
}

