/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.IWizard;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class WizardStep
extends Panel
implements IWizardStep {
    private static final long serialVersionUID = 1L;
    private boolean complete = true;
    private IModel<String> summary;
    private IModel<String> title;
    private IWizardModel wizardModel;
    private FormValidatorWrapper formValidatorWrapper = new FormValidatorWrapper();

    public WizardStep() {
        super("view");
    }

    public WizardStep(IModel<String> title, IModel<String> summary) {
        this(title, summary, null);
    }

    public WizardStep(IModel<String> title, IModel<String> summary, IModel<?> model) {
        super("view", model);
        this.title = this.wrap(title);
        this.summary = this.wrap(summary);
    }

    public WizardStep(String title, String summary) {
        this(title, summary, null);
    }

    public WizardStep(String title, String summary, IModel<?> model) {
        this((IModel<String>)new Model((Serializable)((Object)title)), (IModel<String>)new Model((Serializable)((Object)summary)), model);
    }

    public final void add(IFormValidator validator) {
        this.formValidatorWrapper.add(validator);
    }

    @Override
    public void applyState() {
    }

    @Override
    public Component getHeader(String id, Component parent, IWizard wizard) {
        return new Header(id, wizard);
    }

    public String getSummary() {
        return this.summary != null ? (String)this.summary.getObject() : null;
    }

    public String getTitle() {
        return this.title != null ? (String)this.title.getObject() : null;
    }

    @Override
    public Component getView(String id, Component parent, IWizard wizard) {
        return this;
    }

    @Override
    public final void init(IWizardModel wizardModel) {
        this.wizardModel = wizardModel;
        this.onInit(wizardModel);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void setSummaryModel(IModel<String> summary) {
        this.summary = this.wrap(summary);
    }

    public void setTitleModel(IModel<String> title) {
        this.title = this.wrap(title);
    }

    protected void detachModel() {
        super.detachModel();
        if (this.title != null) {
            this.title.detach();
        }
        if (this.summary != null) {
            this.summary.detach();
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        Form form = (Form)this.findParent(Form.class);
        form.add((IFormValidator)this.formValidatorWrapper);
    }

    protected void onInit(IWizardModel wizardModel) {
    }

    public IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    private final class FormValidatorWrapper
    implements IFormValidator {
        private static final long serialVersionUID = 1L;
        private final List<IFormValidator> validators = new ArrayList<IFormValidator>();

        private FormValidatorWrapper() {
        }

        public final void add(IFormValidator validator) {
            this.validators.add(validator);
        }

        public FormComponent<?>[] getDependentFormComponents() {
            if (this.isActiveStep()) {
                HashSet<FormComponent> components = new HashSet<FormComponent>();
                for (IFormValidator v : this.validators) {
                    FormComponent[] dependentComponents = v.getDependentFormComponents();
                    if (dependentComponents == null) continue;
                    int len = dependentComponents.length;
                    components.addAll(Arrays.asList(dependentComponents).subList(0, len));
                }
                return components.toArray(new FormComponent[components.size()]);
            }
            return null;
        }

        public void validate(Form<?> form) {
            if (this.isActiveStep()) {
                for (IFormValidator v : this.validators) {
                    v.validate(form);
                }
            }
        }

        private boolean isActiveStep() {
            return WizardStep.this.wizardModel.getActiveStep().equals(WizardStep.this);
        }
    }

    private final class Header
    extends Panel {
        private static final long serialVersionUID = 1L;

        public Header(String id, IWizard wizard) {
            super(id);
            this.setDefaultModel((IModel)new CompoundPropertyModel((Object)wizard));
            this.add(new Component[]{new Label("title", WizardStep.this::getTitle)});
            this.add(new Component[]{new Label("summary", WizardStep.this::getSummary)});
        }
    }
}

