/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class ProducerTask
extends Task {
    private Vector filesets = new Vector();
    private Messenger messenger;
    private String messengerName;
    private Destination destination;
    private String subject;
    private MessengerManager messengerManager;
    private File file;
    private long sleep;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public Messenger getMessenger() throws JMSException {
        if (this.messenger == null) {
            this.messenger = this.getMessengerManager().getMessenger(this.getMessengerName());
        }
        return this.messenger;
    }

    public void setMessenger(Messenger messenger) {
        this.messenger = messenger;
    }

    public String getMessengerName() {
        return this.messengerName;
    }

    public void setMessengerName(String messengerName) {
        this.messengerName = messengerName;
    }

    public Destination getDestination() throws JMSException {
        if (this.destination == null) {
            this.destination = this.getMessenger().getDestination(this.getSubject());
        }
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public MessengerManager getMessengerManager() {
        return this.messengerManager;
    }

    public void setMessengerManager(MessengerManager messengerManager) {
        this.messengerManager = messengerManager;
    }

    public void setConfiguration(String uri) throws JMSException {
        this.setMessengerManager(MessengerManager.load(uri));
    }

    public long getSleep() {
        return this.sleep;
    }

    public void setSleep(long sleep) {
        this.sleep = sleep;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        try {
            try {
                if (this.filesets.size() == 0) {
                    throw new BuildException("Specify at least one source fileset.", this.location);
                }
                Messenger messenger = this.getMessenger();
                if (messenger == null) {
                    throw new BuildException("Must specify a valid Messenger", this.location);
                }
                Destination destination = this.getDestination();
                if (destination == null) {
                    throw new BuildException("Must specify a valid JMS Destination", this.location);
                }
                if (this.sleep > 0L) {
                    this.log("Will sleep for: " + this.sleep + " (ms) between message sends");
                }
                boolean first = true;
                if (this.file != null) {
                    this.sendFile(this.file, messenger, destination);
                } else {
                    Iterator iter = ((AbstractList)this.filesets).iterator();
                    while (iter.hasNext()) {
                        FileSet fs = (FileSet)iter.next();
                        DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
                        ds.scan();
                        File dir = ds.getBasedir();
                        String[] files = ds.getIncludedFiles();
                        int i = 0;
                        while (i < files.length) {
                            if (first) {
                                first = false;
                            } else {
                                this.sleep();
                            }
                            this.sendFile(new File(dir, files[i]), messenger, destination);
                            ++i;
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.location);
            }
            catch (JMSException e) {
                throw new BuildException((Throwable)e, this.location);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            try {
                this.messenger.close();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        this.messenger.close();
        return;
    }

    protected void sendFile(File file, Messenger messenger, Destination destination) throws IOException, JMSException {
        this.log("Sending message to: " + destination + " from file: " + file);
        String text = this.readText(new BufferedReader(new FileReader(file)));
        TextMessage message = messenger.createTextMessage(text);
        messenger.send(destination, (Message)message);
    }

    /*
     * WARNING - void declaration
     */
    protected String readText(Reader in) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        BufferedReader reader = new BufferedReader(in);
        while ((line = reader.readLine()) != null) {
            void var4_4;
            buffer.append((String)var4_4);
            buffer.append('\n');
        }
        reader.close();
        return buffer.toString();
    }

    protected void sleep() {
        block2: {
            if (this.sleep <= 0L) break block2;
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException e) {}
        }
    }
}

