/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.outbound;

import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionRequestInfo;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.PoolingAttributes;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;

public class MultiPoolConnectionInterceptor
implements ConnectionInterceptor,
PoolingAttributes {
    private final ConnectionInterceptor next;
    private final PoolingSupport singlePoolFactory;
    private final boolean useSubject;
    private final boolean useCRI;
    private final Map<SubjectCRIKey, PoolingAttributes> pools = new HashMap<SubjectCRIKey, PoolingAttributes>();
    private volatile boolean destroyed = false;

    public MultiPoolConnectionInterceptor(ConnectionInterceptor next, PoolingSupport singlePoolFactory, boolean useSubject, boolean useCRI) {
        this.next = next;
        this.singlePoolFactory = singlePoolFactory;
        this.useSubject = useSubject;
        this.useCRI = useCRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getConnection(ConnectionInfo connectionInfo) throws ResourceException {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        SubjectCRIKey key = new SubjectCRIKey(this.useSubject ? mci.getSubject() : null, this.useCRI ? mci.getConnectionRequestInfo() : null);
        ConnectionInterceptor poolInterceptor = null;
        Map<SubjectCRIKey, PoolingAttributes> map = this.pools;
        synchronized (map) {
            if (this.destroyed) {
                throw new ResourceException("ConnectionManaged has been destroyed");
            }
            poolInterceptor = (ConnectionInterceptor)((Object)this.pools.get(key));
            if (poolInterceptor == null) {
                poolInterceptor = this.singlePoolFactory.addPoolingInterceptors(this.next);
                this.pools.put(key, (PoolingAttributes)((Object)poolInterceptor));
            }
        }
        poolInterceptor.getConnection(connectionInfo);
        connectionInfo.getManagedConnectionInfo().setPoolInterceptor(poolInterceptor);
    }

    @Override
    public void returnConnection(ConnectionInfo connectionInfo, ConnectionReturnAction connectionReturnAction) {
        ManagedConnectionInfo mci = connectionInfo.getManagedConnectionInfo();
        ConnectionInterceptor poolInterceptor = mci.getPoolInterceptor();
        poolInterceptor.returnConnection(connectionInfo, connectionReturnAction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Map<SubjectCRIKey, PoolingAttributes> map = this.pools;
        synchronized (map) {
            this.destroyed = true;
            for (PoolingAttributes poolingAttributes : this.pools.values()) {
                ConnectionInterceptor poolInterceptor = (ConnectionInterceptor)((Object)poolingAttributes);
                poolInterceptor.destroy();
            }
            this.pools.clear();
        }
        this.next.destroy();
    }

    @Override
    public int getPartitionCount() {
        return this.pools.size();
    }

    @Override
    public int getPartitionMaxSize() {
        return this.singlePoolFactory.getPartitionMaxSize();
    }

    @Override
    public void setPartitionMaxSize(int maxSize) throws InterruptedException {
        this.singlePoolFactory.setPartitionMaxSize(maxSize);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setPartitionMaxSize(maxSize);
        }
    }

    @Override
    public int getPartitionMinSize() {
        return this.singlePoolFactory.getPartitionMinSize();
    }

    @Override
    public void setPartitionMinSize(int minSize) {
        this.singlePoolFactory.setPartitionMinSize(minSize);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setPartitionMinSize(minSize);
        }
    }

    @Override
    public int getIdleConnectionCount() {
        int count = 0;
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            count += poolingAttributes.getIdleConnectionCount();
        }
        return count;
    }

    @Override
    public int getConnectionCount() {
        int count = 0;
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            count += poolingAttributes.getConnectionCount();
        }
        return count;
    }

    @Override
    public int getBlockingTimeoutMilliseconds() {
        return this.singlePoolFactory.getBlockingTimeoutMilliseconds();
    }

    @Override
    public void setBlockingTimeoutMilliseconds(int timeoutMilliseconds) {
        this.singlePoolFactory.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setBlockingTimeoutMilliseconds(timeoutMilliseconds);
        }
    }

    @Override
    public int getIdleTimeoutMinutes() {
        return this.singlePoolFactory.getIdleTimeoutMinutes();
    }

    @Override
    public void setIdleTimeoutMinutes(int idleTimeoutMinutes) {
        this.singlePoolFactory.setIdleTimeoutMinutes(idleTimeoutMinutes);
        for (PoolingAttributes poolingAttributes : this.pools.values()) {
            poolingAttributes.setIdleTimeoutMinutes(idleTimeoutMinutes);
        }
    }

    @Override
    public void info(StringBuilder s) {
        s.append(this.getClass().getName()).append("[useSubject=").append(this.useSubject).append(",useCRI=").append(this.useCRI).append(",pool count=").append(this.pools.size()).append("]\n");
        this.next.info(s);
    }

    static class SubjectCRIKey {
        private final Subject subject;
        private final ConnectionRequestInfo cri;
        private final int hashcode;

        public SubjectCRIKey(Subject subject, ConnectionRequestInfo cri) {
            this.subject = subject;
            this.cri = cri;
            this.hashcode = (subject == null ? 17 : subject.hashCode() * 17) ^ (cri == null ? 1 : cri.hashCode());
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubjectCRIKey that = (SubjectCRIKey)o;
            if (this.hashcode != that.hashcode) {
                return false;
            }
            if (this.cri != null ? !this.cri.equals((Object)that.cri) : that.cri != null) {
                return false;
            }
            return !(this.subject != null ? !this.subject.equals(that.subject) : that.subject != null);
        }
    }
}

