/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.resolver;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import java.lang.annotation.ElementType;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bval.jsr.resolver.CachingRelevant;
import org.apache.bval.jsr.resolver.CachingTraversableResolver;
import org.apache.bval.util.reflection.Reflection;
import org.apache.commons.weaver.privilizer.Privilizing;

@Privilizing(value={@Privilizing.CallTo(value=Reflection.class)})
public class DefaultTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private static final Logger log = Logger.getLogger(DefaultTraversableResolver.class.getName());
    private static final boolean LOG_FINEST = log.isLoggable(Level.FINEST);
    private static final String PERSISTENCE_UTIL_CLASSNAME = "jakarta.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME = "org.apache.bval.jsr.resolver.JPATraversableResolver";
    private TraversableResolver jpaTR;

    public DefaultTraversableResolver() {
        this.initJpa();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void initJpa() {
        ClassLoader classLoader = Reflection.loaderFromClassOrThread(DefaultTraversableResolver.class);
        try {
            Reflection.toClass(PERSISTENCE_UTIL_CLASSNAME, classLoader);
            if (LOG_FINEST) {
                log.log(Level.FINEST, String.format("Found %s on classpath.", PERSISTENCE_UTIL_CLASSNAME));
            }
        }
        catch (Exception e) {
            log.log(Level.FINEST, String.format("Cannot find %s on classpath. All properties will per default be traversable.", PERSISTENCE_UTIL_CLASSNAME));
            return;
        }
        try {
            Class<?> jpaAwareResolverClass = Reflection.toClass(JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME, classLoader);
            this.jpaTR = (TraversableResolver)jpaAwareResolverClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (LOG_FINEST) {
                log.log(Level.FINEST, String.format("Instantiated an instance of %s.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, String.format("Unable to load or instantiate JPA aware resolver %s. All properties will per default be traversable.", JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME), e);
        }
    }

    @Override
    public boolean needsCaching() {
        return this.jpaTR != null && CachingTraversableResolver.needsCaching(this.jpaTR);
    }
}

