/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet;

import com.google.common.net.MediaType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.net.MediaTypeSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public final class HttpServletSupport {
    @Nonnull
    private static final Logger LOG = LoggerFactory.getLogger(HttpServletSupport.class);

    private HttpServletSupport() {
    }

    public static void addNoCacheHeaders(@Nonnull HttpServletResponse response) {
        response.setHeader("Cache-control", "no-cache, no-store");
        response.setHeader("Pragma", "no-cache");
    }

    public static void setUTF8Encoding(@Nonnull HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
    }

    public static void setContentType(@Nonnull HttpServletResponse response, @Nullable String contentType) {
        response.setHeader("Content-Type", contentType);
    }

    @Nonnull
    public static String getRequestPathWithoutContext(@Nonnull HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (request.getPathInfo() == null) {
            return servletPath;
        }
        return servletPath + request.getPathInfo();
    }

    @Nonnull
    public static URI getFullRequestURI(@Nonnull HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        String encodedQuery = StringSupport.trimOrNull((String)request.getQueryString());
        if (encodedQuery != null) {
            requestUrl.append("?").append(encodedQuery);
        }
        return URI.create(requestUrl.toString());
    }

    public static boolean validateContentType(@Nonnull HttpServletRequest request, @Nonnull Set<MediaType> validTypes, boolean noContentTypeIsValid, boolean isOneOfStrategy) {
        return MediaTypeSupport.validateContentType(request.getContentType(), validTypes, noContentTypeIsValid, isOneOfStrategy);
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    public static List<Locale.LanguageRange> getLanguageRange(@Nonnull HttpServletRequest request) {
        String languages = StringSupport.trimOrNull((String)request.getHeader("Accept-Language"));
        if (languages != null) {
            try {
                return CollectionSupport.copyToList(Locale.LanguageRange.parse(languages));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Could not parse provided languages '{}'", (Object)languages, (Object)e);
            }
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public static String getRemoteAddr(@Nonnull ServletRequest request) {
        String addr = request.getRemoteAddr();
        if (addr != null && addr.startsWith("[") && addr.endsWith("]")) {
            return addr.substring(1, addr.length() - 1);
        }
        return addr;
    }
}

