/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV2;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV3;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONUntypedMessageSerializerV1;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONUntypedMessageSerializerV2;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONUntypedMessageSerializerV3;

public enum Serializers {
    GRAPHSON("application/json"),
    GRAPHSON_V1("application/vnd.gremlin-v1.0+json"),
    GRAPHSON_V1_UNTYPED("application/vnd.gremlin-v1.0+json;types=false"),
    GRAPHSON_V2("application/vnd.gremlin-v2.0+json"),
    GRAPHSON_V2_UNTYPED("application/vnd.gremlin-v2.0+json;types=false"),
    GRAPHSON_V3("application/vnd.gremlin-v3.0+json"),
    GRAPHSON_V3_UNTYPED("application/vnd.gremlin-v3.0+json;types=false"),
    GRAPHBINARY_V1("application/vnd.graphbinary-v1.0");

    private String value;

    private Serializers(String mimeType) {
        this.value = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public MessageSerializer<?> simpleInstance() {
        switch (this.value) {
            case "application/json": 
            case "application/vnd.gremlin-v3.0+json": {
                return new GraphSONMessageSerializerV3();
            }
            case "application/vnd.gremlin-v1.0+json": {
                return new GraphSONMessageSerializerV1();
            }
            case "application/vnd.gremlin-v1.0+json;types=false": {
                return new GraphSONUntypedMessageSerializerV1();
            }
            case "application/vnd.gremlin-v2.0+json": {
                return new GraphSONMessageSerializerV2();
            }
            case "application/vnd.gremlin-v2.0+json;types=false": {
                return new GraphSONUntypedMessageSerializerV2();
            }
            case "application/vnd.gremlin-v3.0+json;types=false": {
                return new GraphSONUntypedMessageSerializerV3();
            }
            case "application/vnd.graphbinary-v1.0": {
                return new GraphBinaryMessageSerializerV1();
            }
        }
        throw new RuntimeException("Could not create a simple MessageSerializer instance of " + this.value);
    }
}

