/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.tokens;

import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.lucene.util.PriorityQueue;
import org.apache.tika.eval.core.tokens.ContrastStatistics;
import org.apache.tika.eval.core.tokens.TokenCountPriorityQueue;
import org.apache.tika.eval.core.tokens.TokenCounts;
import org.apache.tika.eval.core.tokens.TokenIntPair;

public class TokenContraster {
    private TokenCounts tokensA;
    private TokenCounts tokensB;
    private TokenCountPriorityQueue uniqA;
    private TokenCountPriorityQueue uniqB;
    private TokenCountDiffQueue moreA;
    private TokenCountDiffQueue moreB;
    private int topN = 10;
    private int diceCoefficientNum = 0;
    private int overlapNum = 0;
    private double diceCoefficient = 0.0;
    private double overlap = 0.0;

    public ContrastStatistics calculateContrastStatistics(TokenCounts tokensA, TokenCounts tokensB) {
        this.reset();
        this.tokensA = tokensA;
        this.tokensB = tokensB;
        Map<String, MutableInt> mapA = tokensA.getTokens();
        Map<String, MutableInt> mapB = tokensB.getTokens();
        for (Map.Entry<String, MutableInt> e : mapA.entrySet()) {
            MutableInt bVal = mapB.get(e.getKey());
            int b = bVal == null ? 0 : bVal.intValue();
            this.add(e.getKey(), e.getValue().intValue(), b);
        }
        for (Map.Entry<String, MutableInt> e : mapB.entrySet()) {
            if (mapA.containsKey(e.getKey())) continue;
            this.add(e.getKey(), 0, e.getValue().intValue());
        }
        this.finishComputing();
        ContrastStatistics contrastStatistics = new ContrastStatistics();
        contrastStatistics.setDiceCoefficient(this.diceCoefficient);
        contrastStatistics.setOverlap(this.overlap);
        contrastStatistics.setTopNUniqueA(this.uniqA.getArray());
        contrastStatistics.setTopNUniqueB(this.uniqB.getArray());
        contrastStatistics.setTopNMoreA(this.moreA.getArray());
        contrastStatistics.setTopNMoreB(this.moreB.getArray());
        return contrastStatistics;
    }

    private void reset() {
        this.uniqA = new TokenCountPriorityQueue(this.topN);
        this.uniqB = new TokenCountPriorityQueue(this.topN);
        this.moreA = new TokenCountDiffQueue(this.topN);
        this.moreB = new TokenCountDiffQueue(this.topN);
        this.diceCoefficientNum = 0;
        this.overlapNum = 0;
        this.diceCoefficient = 0.0;
        this.overlap = 0.0;
    }

    private void add(String token, int tokenCountA, int tokenCountB) {
        if (tokenCountA > 0 && tokenCountB > 0) {
            this.diceCoefficientNum += 2;
            this.overlapNum += 2 * Math.min(tokenCountA, tokenCountB);
        }
        if ((long)tokenCountA == 0L && (long)tokenCountB > 0L) {
            this.addToken(token, tokenCountB, this.uniqB);
        }
        if ((long)tokenCountB == 0L && (long)tokenCountA > 0L) {
            this.addToken(token, tokenCountA, this.uniqA);
        }
        if (tokenCountA > tokenCountB) {
            this.addTokenDiff(token, tokenCountA, tokenCountA - tokenCountB, this.moreA);
        } else if (tokenCountB > tokenCountA) {
            this.addTokenDiff(token, tokenCountB, tokenCountB - tokenCountA, this.moreB);
        }
    }

    private void finishComputing() {
        long sumUniqTokens = this.tokensA.getTotalUniqueTokens() + this.tokensB.getTotalUniqueTokens();
        this.diceCoefficient = (double)this.diceCoefficientNum / (double)sumUniqTokens;
        this.overlap = (double)this.overlapNum / (double)(this.tokensA.getTotalTokens() + this.tokensB.getTotalTokens());
    }

    private void addTokenDiff(String token, int tokenCount, int diff, TokenCountDiffQueue queue) {
        if (queue.top() == null || queue.size() < this.topN || diff >= ((TokenCountDiff)queue.top()).diff) {
            queue.insertWithOverflow(new TokenCountDiff(token, diff, tokenCount));
        }
    }

    private void addToken(String token, int tokenCount, TokenCountPriorityQueue queue) {
        if (queue.top() == null || queue.size() < this.topN || (long)tokenCount >= ((TokenIntPair)queue.top()).getValue()) {
            queue.insertWithOverflow(new TokenIntPair(token, tokenCount));
        }
    }

    private static class TokenCountDiff {
        private final String token;
        private final int diff;
        private final int count;

        private TokenCountDiff(String token, int diff, int count) {
            this.token = token;
            this.diff = diff;
            this.count = count;
        }
    }

    static class TokenCountDiffQueue
    extends PriorityQueue<TokenCountDiff> {
        TokenCountDiffQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        protected boolean lessThan(TokenCountDiff arg0, TokenCountDiff arg1) {
            if (arg0.diff < arg1.diff) {
                return true;
            }
            if (arg0.diff > arg1.diff) {
                return false;
            }
            return arg1.token.compareTo(arg0.token) < 0;
        }

        public TokenIntPair[] getArray() {
            TokenIntPair[] topN = new TokenIntPair[this.size()];
            TokenCountDiff token = (TokenCountDiff)this.pop();
            int i = topN.length - 1;
            while (token != null && i > -1) {
                topN[i--] = new TokenIntPair(token.token, token.diff);
                token = (TokenCountDiff)this.pop();
            }
            return topN;
        }
    }
}

