/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DoubleWritable
implements WritableComparable<DoubleWritable> {
    private double value = 0.0;

    public DoubleWritable() {
    }

    public DoubleWritable(double value) {
        this.set(value);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    public void set(double value) {
        this.value = value;
    }

    public double get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleWritable)) {
            return false;
        }
        DoubleWritable other = (DoubleWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.value);
    }

    @Override
    public int compareTo(DoubleWritable o) {
        return this.value < o.value ? -1 : (this.value == o.value ? 0 : 1);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    static {
        WritableComparator.define(DoubleWritable.class, (WritableComparator)new Comparator());
    }
}

