/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.xing.login.impl;

import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="Apache Sling Authentication XING Login \u201cAuthentication Handler\u201d", description="Authentication Handler for Sling Authentication XING Login", immediate=true, metatype=true)
@Service
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Authentication Handler for Sling Authentication XING Login"}), @Property(name="service.ranking", intValue={0}, propertyPrivate=false), @Property(name="path", value={"/"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="authtype", value={"xing-login"}, propertyPrivate=true)})
public class XingLoginAuthenticationHandler
extends DefaultAuthenticationFeedbackHandler
implements AuthenticationHandler {
    private String consumerKey;
    private String xingCookie;
    private String userCookie;
    private String userIdCookie;
    private int maxCookieSize;
    private String loginPath;
    private String logoutPath;
    private ServiceRegistration loginPageRegistration;
    private static final String DEFAULT_USER_COOKIE = "sling_auth_xing_user";
    private static final String DEFAULT_USERID_COOKIE = "sling_auth_xing_userid";
    private static final int DEFAULT_MAX_COOKIE_SIZE = 4096;
    @Property(value={""})
    private static final String CONSUMER_KEY_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.consumerKey";
    @Property(value={"sling_auth_xing_user"})
    private static final String USER_COOKIE_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.cookie.user";
    @Property(value={"sling_auth_xing_userid"})
    private static final String USERID_COOKIE_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.cookie.userid";
    @Property(intValue={4096})
    private static final String MAX_COOKIE_SIZE_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.cookie.maxSize";
    @Property
    private static final String LOGIN_PATH_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.login.path";
    @Property
    private static final String LOGOUT_PATH_PARAMETER = "org.apache.sling.auth.xing.login.impl.XingLoginAuthenticationHandler.logout.path";
    private final Logger logger = LoggerFactory.getLogger(XingLoginAuthenticationHandler.class);

    @Activate
    protected void activate(ComponentContext ComponentContext2) {
        this.logger.debug("activate");
        this.configure(ComponentContext2);
    }

    @Modified
    protected void modified(ComponentContext ComponentContext2) {
        this.logger.debug("modified");
        this.configure(ComponentContext2);
    }

    @Deactivate
    protected void deactivate(ComponentContext ComponentContext2) {
        this.logger.debug("deactivate");
        if (this.loginPageRegistration != null) {
            this.loginPageRegistration.unregister();
            this.loginPageRegistration = null;
        }
    }

    protected void configure(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.consumerKey = PropertiesUtil.toString(properties.get(CONSUMER_KEY_PARAMETER), "").trim();
        this.userCookie = PropertiesUtil.toString(properties.get(USER_COOKIE_PARAMETER), DEFAULT_USER_COOKIE).trim();
        this.userIdCookie = PropertiesUtil.toString(properties.get(USERID_COOKIE_PARAMETER), DEFAULT_USERID_COOKIE).trim();
        this.maxCookieSize = PropertiesUtil.toInteger(properties.get(MAX_COOKIE_SIZE_PARAMETER), 4096);
        this.loginPath = PropertiesUtil.toString(properties.get(LOGIN_PATH_PARAMETER), "").trim();
        this.logoutPath = PropertiesUtil.toString(properties.get(LOGOUT_PATH_PARAMETER), "").trim();
        if (StringUtils.isEmpty((String)this.consumerKey)) {
            this.logger.warn("configured consumer key is empty");
            this.xingCookie = "";
        } else {
            this.xingCookie = "xing_p_lw_s_".concat(this.consumerKey);
        }
        if (this.loginPageRegistration != null) {
            this.loginPageRegistration.unregister();
        }
        if (StringUtils.isEmpty((String)this.loginPath)) {
            this.logger.warn("configured login path is empty");
        } else {
            Hashtable<String, String[]> loginPathProperties = new Hashtable<String, String[]>();
            String[] authRequirements = new String[]{"-".concat(this.loginPath)};
            ((Dictionary)loginPathProperties).put("sling.auth.requirements", authRequirements);
            this.loginPageRegistration = context.getBundleContext().registerService(Object.class.getName(), new Object(), loginPathProperties);
        }
        if (StringUtils.isEmpty((String)this.logoutPath)) {
            this.logger.warn("configured logout path is empty");
        }
        this.logger.info("configured with consumer key '{}', cookie name '{}', login path '{}' and logout path '{}'", new Object[]{this.consumerKey, this.xingCookie, this.loginPath, this.logoutPath});
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        this.logger.debug("extract credentials");
        String hash = null;
        String user = null;
        String userId = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (cookieName.equals(this.xingCookie)) {
                    hash = this.readCookieValue(cookie);
                    this.logger.debug("\u201cLogin with XING\u201d cookie found: {}", (Object)hash);
                    continue;
                }
                if (cookieName.equals(this.userCookie)) {
                    user = this.readCookieValue(cookie);
                    continue;
                }
                if (!cookieName.equals(this.userIdCookie)) continue;
                userId = this.readCookieValue(cookie);
            }
        }
        if (!(StringUtils.isEmpty(hash) || StringUtils.isEmpty(userId) || StringUtils.isEmpty(user))) {
            this.logger.debug("valid cookies with hash and user data and id found");
            AuthenticationInfo authenticationInfo = new AuthenticationInfo("xing-login", userId);
            authenticationInfo.put("xing-hash", hash);
            authenticationInfo.put("xing-userdata", user);
            return authenticationInfo;
        }
        this.logger.debug("unable to extract credentials from request");
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug("request credentials");
        if (!this.loginPath.equals(request.getServletPath())) {
            String target = request.getContextPath().concat(this.loginPath);
            this.logger.debug("redirecting to '{}'", (Object)target);
            AuthUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)target, null);
        }
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.logger.debug("drop credentials");
        this.deleteCookies(request, response);
        HashMap params = new HashMap();
        this.logger.debug("redirecting to '{}'", (Object)this.logoutPath);
        AuthUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)this.logoutPath, params);
    }

    protected String readCookieValue(Cookie cookie) {
        if (cookie.getValue() != null) {
            if (cookie.getValue().length() > this.maxCookieSize) {
                this.logger.warn("size of cookie value greater than configured max. cookie size of {}", (Object)this.maxCookieSize);
            } else {
                return cookie.getValue();
            }
        }
        return null;
    }

    protected void deleteCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                this.logger.debug("cookie found: '{}'", (Object)name);
                if (!name.equals(this.xingCookie) && !name.equals(this.userCookie) && !name.equals(this.userIdCookie)) continue;
                this.logger.debug("deleting cookie '{}' with value '{}'", (Object)cookie.getName(), (Object)cookie.getValue());
                cookie.setValue(null);
                cookie.setMaxAge(0);
                response.addCookie(cookie);
            }
        }
    }
}

