/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.websocket;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.Consumer;

public final class WebSocketClientUtil {
    private static final AttributeKey<Consumer<Throwable>> CLOSING_RESPONSE_TASK = AttributeKey.valueOf(WebSocketClientUtil.class, "CLOSING_RESPONSE_TASK");

    public static void setClosingResponseTask(ClientRequestContext ctx, Consumer<Throwable> task) {
        Objects.requireNonNull(ctx, "ctx");
        Objects.requireNonNull(task, "task");
        ctx.setAttr(CLOSING_RESPONSE_TASK, task);
    }

    public static void closingResponse(ClientRequestContext ctx, @Nullable Throwable cause) {
        Objects.requireNonNull(ctx, "ctx");
        Consumer<Throwable> task = ctx.attr(CLOSING_RESPONSE_TASK);
        if (task != null) {
            task.accept(cause);
        }
    }

    private WebSocketClientUtil() {
    }
}

