/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.event.EventQueryCondition;
import org.apache.skywalking.oap.server.core.query.type.event.Events;
import org.apache.skywalking.oap.server.core.storage.query.IEventQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class EventQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IEventQueryDAO dao;

    public EventQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IEventQueryDAO getDao() {
        if (this.dao == null) {
            this.dao = (IEventQueryDAO)this.moduleManager.find("storage").provider().getService(IEventQueryDAO.class);
        }
        return this.dao;
    }

    public Events queryEvents(EventQueryCondition condition) throws Exception {
        if (StringUtil.isBlank((String)condition.getUuid()) && this.isDurationInvalid(condition.getTime())) {
            throw new IllegalArgumentException("time field is required when uuid is absent.");
        }
        return this.getDao().queryEvents(condition);
    }

    public Events queryEvents(List<EventQueryCondition> conditions) throws Exception {
        EventQueryCondition condition = conditions.stream().filter(c -> StringUtil.isBlank((String)c.getUuid()) && this.isDurationInvalid(c.getTime())).findFirst().orElse(null);
        if (Objects.nonNull(condition)) {
            throw new IllegalArgumentException("time field is required when uuid is absent.");
        }
        return this.getDao().queryEvents(conditions);
    }

    boolean isDurationInvalid(Duration duration) {
        return Objects.isNull(duration) || StringUtil.isBlank((String)duration.getStart()) || StringUtil.isBlank((String)duration.getEnd());
    }
}

