/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.channel;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ConnectivityState;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelFactory;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelManagerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManager
extends ManagedChannel {
    private static final Logger log = LoggerFactory.getLogger(ChannelManager.class);
    private final LazyReferenceChannel lazyChannel = new LazyReferenceChannel();
    private static final Set<Status.Code> SC_NETWORK = ImmutableSet.of((Object)Status.Code.UNAVAILABLE, (Object)Status.Code.PERMISSION_DENIED, (Object)Status.Code.UNAUTHENTICATED, (Object)Status.Code.RESOURCE_EXHAUSTED, (Object)Status.Code.UNKNOWN);
    private final ChannelManagerSettings settings;
    private final ChannelFactory channelFactory;
    private final ScheduledExecutorService executor;
    @VisibleForTesting
    final AtomicReference<Entry> entryRef = new AtomicReference();

    public static ChannelManager create(ChannelManagerSettings settings, ChannelFactory channelFactory) throws IOException {
        return new ChannelManager(settings, channelFactory, Executors.newSingleThreadScheduledExecutor());
    }

    ChannelManager(ChannelManagerSettings settings, ChannelFactory channelFactory, ScheduledExecutorService executor) throws IOException {
        this.settings = settings;
        this.channelFactory = channelFactory;
        this.executor = executor;
        this.entryRef.set(new Entry(channelFactory.create()));
        this.executor.scheduleAtFixedRate(this::refreshSafely, settings.refreshInterval(), settings.refreshInterval(), TimeUnit.SECONDS);
    }

    private void refreshSafely() {
        try {
            this.refresh();
        }
        catch (Exception e) {
            log.warn("Failed to refresh channels", (Throwable)e);
        }
    }

    void refresh() throws IOException {
        Entry entry = this.entryRef.get();
        if (!entry.needReconnect) {
            return;
        }
        if (entry.isConnected((long)entry.reconnectCount.incrementAndGet() > this.settings.forceReconnectionThreshold())) {
            entry.reset();
            return;
        }
        Entry replacedEntry = this.entryRef.getAndSet(new Entry(this.channelFactory.create()));
        replacedEntry.shutdown();
    }

    public ManagedChannel shutdown() {
        this.entryRef.get().channel.shutdown();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        return this;
    }

    public boolean isShutdown() {
        if (!this.entryRef.get().channel.isShutdown()) {
            return false;
        }
        return this.executor == null || this.executor.isShutdown();
    }

    public boolean isTerminated() {
        if (!this.entryRef.get().channel.isTerminated()) {
            return false;
        }
        return this.executor == null || this.executor.isTerminated();
    }

    public ManagedChannel shutdownNow() {
        this.entryRef.get().channel.shutdownNow();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        return this;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long endTimeNanos = System.nanoTime() + unit.toNanos(timeout);
        this.entryRef.get().channel.awaitTermination(endTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
        if (this.executor != null) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            this.executor.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
        }
        return this.isTerminated();
    }

    public <REQ, RESP> ClientCall<REQ, RESP> newCall(MethodDescriptor<REQ, RESP> methodDescriptor, CallOptions callOptions) {
        return this.lazyChannel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.entryRef.get().channel.authority();
    }

    static boolean isNetworkError(Status status) {
        return SC_NETWORK.contains(status.getCode());
    }

    static class NetworkExceptionAwareClientCall<REQ, RESP>
    extends ForwardingClientCall.SimpleForwardingClientCall<REQ, RESP> {
        final Entry entry;

        public NetworkExceptionAwareClientCall(ClientCall<REQ, RESP> delegate, Entry entry) {
            super(delegate);
            this.entry = entry;
        }

        public void start(ClientCall.Listener<RESP> responseListener, Metadata headers) {
            super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RESP>(responseListener){

                public void onClose(Status status, Metadata trailers) {
                    if (ChannelManager.isNetworkError(status)) {
                        entry.needReconnect = true;
                    }
                    super.onClose(status, trailers);
                }
            }, headers);
        }
    }

    private class LazyReferenceChannel
    extends Channel {
        private LazyReferenceChannel() {
        }

        public <REQ, RESP> ClientCall<REQ, RESP> newCall(MethodDescriptor<REQ, RESP> methodDescriptor, CallOptions callOptions) {
            Entry entry = ChannelManager.this.entryRef.get();
            return new NetworkExceptionAwareClientCall(entry.channel.newCall(methodDescriptor, callOptions), entry);
        }

        public String authority() {
            return ChannelManager.this.authority();
        }
    }

    static class Entry {
        final ManagedChannel channel;
        final AtomicInteger reconnectCount = new AtomicInteger(0);
        volatile boolean needReconnect = false;

        boolean isConnected(boolean requestConnection) {
            return this.channel.getState(requestConnection) == ConnectivityState.READY;
        }

        void shutdown() {
            this.channel.shutdown();
        }

        void reset() {
            this.needReconnect = false;
            this.reconnectCount.set(0);
        }

        public Entry(ManagedChannel channel) {
            this.channel = channel;
        }
    }
}

