/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gml;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.time.temporal.Temporal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.gml.GMLAdapter;
import org.apache.sis.xml.internal.shared.XmlUtilities;

@XmlType(name="TimeInstantType")
@XmlRootElement(name="TimeInstant")
public final class TimeInstant
extends GMLAdapter {
    @XmlElement
    public XMLGregorianCalendar timePosition;

    public TimeInstant() {
    }

    public TimeInstant(Temporal instant) {
        this.timePosition = TimeInstant.toXML(instant);
    }

    static XMLGregorianCalendar toXML(Temporal instant) {
        if (instant != null) {
            Context context = Context.current();
            try {
                return XmlUtilities.toXML(context, instant);
            }
            catch (IllegalArgumentException | DatatypeConfigurationException e) {
                Context.warningOccured(context, TimeInstant.class, "toXML", e, true);
            }
        }
        return null;
    }

    public String toString() {
        return Strings.bracket(this.getClass(), (Object)this.timePosition);
    }
}

