/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper;

import java.util.EnumMap;
import java.util.Locale;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Names;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public enum GeometryType {
    GEOMETRY("Geometry", false),
    POINT("Point", false),
    LINESTRING("LineString", false),
    POLYGON("Polygon", false),
    MULTIPOINT("MultiPoint", true),
    MULTILINESTRING("MultiLineString", true),
    MULTIPOLYGON("MultiPolygon", true),
    GEOMETRYCOLLECTION("GeometryCollection", true),
    CIRCULARSTRING("CircularString", false),
    COMPOUNDCURVE("CompoundCurve", true),
    CURVEPOLYGON("CurvePolygon", false),
    MULTICURVE("MultiCurve", true),
    MULTISURFACE("MultiSurface", true),
    CURVE("Curve", false),
    SURFACE("Surface", false),
    POLYHEDRALSURFACE("PolyhedralSurface", true),
    TIN("Tin", true),
    TRIANGLE("Triangle", false),
    CIRCLE("Circle", false),
    GEODESICSTRING("GeodesicString", false),
    ELLIPTICALCURVE("EllipticalCurve", false),
    NURBSCURVE("NurbsCurve", false),
    CLOTHOID("Clothoid", false),
    SPIRALCURVE("SpiralCurve", false),
    COMPOUNDSURFACE("CompoundSurface", true),
    BREPSOLID("BrepSolid", false);

    private static final GeometryType[] VALUES;
    public final String name;
    public final boolean isCollection;
    private GeometryType related;
    private final EnumMap<GeometryLibrary, TypeName> typeNames;
    private static volatile NameSpace namespace;

    private void contains(GeometryType component) {
        this.related = component;
        component.related = this;
    }

    private GeometryType(String name, boolean isCollection) {
        this.name = name;
        this.isCollection = isCollection;
        this.typeNames = new EnumMap(GeometryLibrary.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TypeName getTypeName(Geometries<?> library) {
        TypeName value;
        EnumMap<GeometryLibrary, TypeName> enumMap = this.typeNames;
        synchronized (enumMap) {
            value = this.typeNames.get(library.library);
        }
        if (value == null) {
            NameSpace scope = namespace;
            if (scope == null) {
                namespace = scope = Names.createTypeName((CharSequence)"OGC", null, (CharSequence)"Geometry").scope();
            }
            value = DefaultNameFactory.provider().createTypeName(scope, (CharSequence)this.name, library.getGeometryClass(this));
            EnumMap<GeometryLibrary, TypeName> enumMap2 = this.typeNames;
            synchronized (enumMap2) {
                TypeName existing = this.typeNames.put(library.library, value);
                if (existing != null) {
                    value = existing;
                    this.typeNames.put(library.library, value);
                }
            }
        }
        return value;
    }

    public final GeometryType collection() {
        return this.isCollection ? null : this.related;
    }

    public final GeometryType component() {
        return this.isCollection ? this.related : null;
    }

    public final int binaryType() {
        return this.ordinal();
    }

    public static boolean hasZ(int type) {
        return type < 0 || type >= 1000 && type < 2000 || type >= 3000 && type < 4000;
    }

    public static boolean hasM(int type) {
        return (type &= Integer.MAX_VALUE) >= 2000 && type < 4000;
    }

    public static GeometryType forBinaryType(int type) {
        if ((type &= Integer.MAX_VALUE) < 4000 && (type %= 1000) < VALUES.length) {
            return VALUES[type];
        }
        return null;
    }

    public static GeometryType forName(String name) {
        int length;
        if (name != null && (length = (name = name.trim().toUpperCase(Locale.US)).length()) > 0) {
            if (name.charAt(length - 1) == 'M') {
                --length;
            }
            if (length > 0 && name.charAt(length - 1) == 'Z') {
                --length;
            }
            if ((name = name.substring(0, length).replace("_", "")).equals("GEOMCOLLECTION")) {
                return GEOMETRYCOLLECTION;
            }
            return GeometryType.valueOf(name);
        }
        return null;
    }

    public static GeometryType forISO(org.opengis.metadata.acquisition.GeometryType type) {
        if (org.opengis.metadata.acquisition.GeometryType.POINT.equals((Object)type)) {
            return POINT;
        }
        if (org.opengis.metadata.acquisition.GeometryType.LINEAR.equals((Object)type)) {
            return LINESTRING;
        }
        if (org.opengis.metadata.acquisition.GeometryType.AREAL.equals((Object)type)) {
            return POLYGON;
        }
        return null;
    }

    public static boolean isKnown(String name) {
        for (GeometryType value : VALUES) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    static {
        MULTIPOINT.contains(POINT);
        MULTILINESTRING.contains(LINESTRING);
        MULTIPOLYGON.contains(POLYGON);
        GEOMETRYCOLLECTION.contains(GEOMETRY);
        COMPOUNDCURVE.contains(CURVE);
        MULTICURVE.contains(CURVE);
        POLYHEDRALSURFACE.contains(SURFACE);
        COMPOUNDSURFACE.contains(SURFACE);
        MULTISURFACE.contains(SURFACE);
        TIN.contains(TRIANGLE);
        VALUES = GeometryType.values();
    }
}

