/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.handler;

import com.google.common.collect.Maps;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.base.handler.MetaDataHandler;
import org.apache.shenyu.plugin.sofa.cache.ApplicationConfigCache;

public class SofaMetaDataHandler
implements MetaDataHandler {
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();

    public void handle(MetaData metaData) {
        MetaData exist = (MetaData)META_DATA.get(metaData.getPath());
        if (Objects.isNull(exist) || Objects.isNull(ApplicationConfigCache.getInstance().get(exist.getPath()).refer())) {
            ApplicationConfigCache.getInstance().initRef(metaData);
        } else if (!exist.getServiceName().equals(metaData.getServiceName()) || !exist.getRpcExt().equals(metaData.getRpcExt())) {
            ApplicationConfigCache.getInstance().invalidateWithMetadataPath(metaData.getPath());
            ApplicationConfigCache.getInstance().build(metaData);
        }
        META_DATA.put(metaData.getPath(), metaData);
    }

    public void remove(MetaData metaData) {
        ApplicationConfigCache.getInstance().invalidateWithMetadataPath(metaData.getPath());
        META_DATA.remove(metaData.getPath());
    }

    public String rpcType() {
        return RpcTypeEnum.SOFA.getName();
    }
}

