/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.ProxyApiKeyData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.sync.data.api.AiProxyApiKeyDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiProxyApiKeyDataRefresh
extends AbstractDataRefresh<ProxyApiKeyData> {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyApiKeyDataRefresh.class);
    private final List<AiProxyApiKeyDataSubscriber> subscribers;

    public AiProxyApiKeyDataRefresh(List<AiProxyApiKeyDataSubscriber> subscribers) {
        this.subscribers = subscribers;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.AI_PROXY_API_KEY.name());
    }

    @Override
    protected ConfigData<ProxyApiKeyData> fromJson(JsonObject data) {
        return (ConfigData)GsonUtils.getGson().fromJson((JsonElement)data, new TypeToken<ConfigData<ProxyApiKeyData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<ProxyApiKeyData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.AI_PROXY_API_KEY);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.AI_PROXY_API_KEY);
    }

    @Override
    protected void refresh(List<ProxyApiKeyData> data) {
        if (CollectionUtils.isEmpty(this.subscribers)) {
            LOG.info("[AiProxySync][HTTP] no subscribers, skip refresh");
            return;
        }
        this.subscribers.forEach(AiProxyApiKeyDataSubscriber::refresh);
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("[AiProxySync][HTTP] received empty list, only refresh called");
            return;
        }
        for (ProxyApiKeyData item : data) {
            for (AiProxyApiKeyDataSubscriber s : this.subscribers) {
                s.onSubscribe(item);
            }
        }
    }
}

