/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.DynamicPropertySupport;
import com.netflix.config.ExpandedConfigurationListenerAdapter;
import com.netflix.config.PropertyListener;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;

public class ConfigurationBackedDynamicPropertySupportImpl
implements DynamicPropertySupport {
    private final AbstractConfiguration config;

    public ConfigurationBackedDynamicPropertySupportImpl(AbstractConfiguration abstractConfiguration) {
        this.config = abstractConfiguration;
    }

    @Override
    public String getString(String string) {
        try {
            String[] stringArray = this.config.getStringArray(string);
            if (stringArray == null) {
                return null;
            }
            if (stringArray.length == 0) {
                return this.config.getString(string);
            }
            if (stringArray.length == 1) {
                return stringArray[0];
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]);
                if (i == stringArray.length - 1) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Object object = this.config.getProperty(string);
            if (object != null) {
                return String.valueOf(object);
            }
            return null;
        }
    }

    @Override
    public void addConfigurationListener(PropertyListener propertyListener) {
        ExpandedConfigurationListenerAdapter expandedConfigurationListenerAdapter = new ExpandedConfigurationListenerAdapter(propertyListener);
        this.config.addConfigurationListener((ConfigurationListener)expandedConfigurationListenerAdapter);
    }

    public final AbstractConfiguration getConfiguration() {
        return this.config;
    }
}

