/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.client.ticket.Ticket;
import com.qq.tars.net.client.ticket.TicketManager;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.UDPSession;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class WorkThread
implements Runnable {
    private Request req;
    private Response resp;
    private SelectorManager selectorManager = null;
    private final UDPSession udpSession;
    private ByteBuffer udpBuffer;

    public Request getRequest() {
        return this.req;
    }

    WorkThread(Response resp, SelectorManager selectorManager) {
        this.resp = resp;
        this.udpSession = null;
    }

    WorkThread(Request req, SelectorManager selectorManager) {
        this.req = req;
        this.udpSession = null;
        this.selectorManager = selectorManager;
    }

    WorkThread(UDPSession session, ByteBuffer buffer, SelectorManager selectorManager) {
        this.udpSession = session;
        this.udpBuffer = buffer;
        this.selectorManager = selectorManager;
    }

    private void parseDatagramPacket() throws IOException {
        Object obj = this.udpSession.parseDatagramPacket(this.udpBuffer);
        if (obj instanceof Request) {
            this.req = (Request)obj;
        } else if (obj instanceof Response) {
            this.resp = (Response)obj;
        }
    }

    @Override
    public void run() {
        try {
            if (this.udpSession != null) {
                this.parseDatagramPacket();
                this.udpBuffer = null;
            }
            if (this.req != null) {
                this.req.setProcessTime(System.currentTimeMillis());
                this.req.init();
                Response res = this.selectorManager.getProcessor().process(this.req, this.req.getIoSession());
                if (!res.isAsyncMode()) {
                    this.req.getIoSession().write(res);
                }
            } else if (this.resp != null) {
                this.resp.init();
                Ticket<Response> ticket = TicketManager.getTicket(this.resp.getTicketNumber());
                if (ticket == null) {
                    String s = "failed to fetch request for this response. [from:" + this.resp.getSession().getRemoteIp() + ":" + this.resp.getSession().getRemotePort() + "]";
                    System.out.println(s);
                    return;
                }
                ticket.notifyResponse(this.resp);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.clearDistributedContext();
        }
    }

    private void clearDistributedContext() {
    }
}

