/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oltu.oauth2.common.parameters;

import java.util.Map;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.OAuthMessage;
import org.apache.oltu.oauth2.common.parameters.OAuthParametersApplier;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;

public class FragmentParametersApplier
implements OAuthParametersApplier {
    @Override
    public OAuthMessage applyOAuthParameters(OAuthMessage message, Map<String, Object> params) throws OAuthSystemException {
        String messageUrl = message.getLocationUri();
        if (messageUrl != null) {
            String fragmentQuery;
            StringBuilder url = new StringBuilder(messageUrl);
            if (params.containsKey("refresh_token")) {
                params.remove("refresh_token");
            }
            if (!OAuthUtils.isEmpty(fragmentQuery = OAuthUtils.format(params.entrySet(), "UTF-8")) && params.size() > 0) {
                url.append("#").append(fragmentQuery);
            }
            message.setLocationUri(url.toString());
        }
        return message;
    }
}

