/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster.merger;

import java.lang.reflect.Array;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.rpc.cluster.Merger;

public class ArrayMerger
implements Merger<Object[]> {
    public static final ArrayMerger INSTANCE = new ArrayMerger();

    public Object[] merge(Object[] ... items) {
        int i;
        if (ArrayUtils.isEmpty((Object[])items)) {
            return new Object[0];
        }
        for (i = 0; i < items.length && items[i] == null; ++i) {
        }
        if (i == items.length) {
            return new Object[0];
        }
        Class<?> type = items[i].getClass().getComponentType();
        int totalLen = 0;
        while (i < items.length) {
            if (items[i] != null) {
                Class<?> itemType = items[i].getClass().getComponentType();
                if (itemType != type) {
                    throw new IllegalArgumentException("Arguments' types are different");
                }
                totalLen += items[i].length;
            }
            ++i;
        }
        if (totalLen == 0) {
            return new Object[0];
        }
        Object result = Array.newInstance(type, totalLen);
        int index = 0;
        for (Object[] array : items) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, index, array.length);
            index += array.length;
        }
        return (Object[])result;
    }
}

