/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.util.HashMap;
import org.apache.shenyu.admin.config.properties.LdapProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@ConditionalOnProperty(name={"shenyu.ldap.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={LdapProperties.class})
public class LdapConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public LdapContextSource contextSource(LdapProperties ldapProp) {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(ldapProp.getUrl());
        contextSource.setUserDn(ldapProp.getBindDn());
        contextSource.setPassword(ldapProp.getPassword());
        contextSource.setPooled(true);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("java.naming.ldap.attributes.binary", "objectGUID");
        config.put("com.sun.jndi.ldap.connect.timeout", String.valueOf(ldapProp.getConnectTimeout()));
        config.put("com.sun.jndi.ldap.read.timeout", String.valueOf(ldapProp.getReadTimeout()));
        contextSource.setBaseEnvironmentProperties(config);
        return contextSource;
    }

    @Bean
    @ConditionalOnMissingBean(value={LdapOperations.class})
    public LdapTemplate ldapTemplate(LdapContextSource ldapContextSource) {
        return new LdapTemplate((ContextSource)ldapContextSource);
    }
}

