/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos;

import com.google.common.util.concurrent.AbstractScheduledService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.mesos.Protos;
import org.apache.mesos.SchedulerDriver;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.FrameworkConfiguration;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconcileService
extends AbstractScheduledService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReconcileService.class);
    private final SchedulerDriver schedulerDriver;
    private final FacadeService facadeService;
    private final ReentrantLock lock = new ReentrantLock();

    protected void runOneIteration() {
        this.lock.lock();
        try {
            this.explicitReconcile();
            this.implicitReconcile();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void explicitReconcile() {
        this.lock.lock();
        try {
            HashSet<TaskContext> runningTask = new HashSet<TaskContext>();
            for (Set<TaskContext> each2 : this.facadeService.getAllRunningTasks().values()) {
                runningTask.addAll(each2);
            }
            if (runningTask.isEmpty()) {
                return;
            }
            log.info("Requesting {} tasks reconciliation with the Mesos master", (Object)runningTask.size());
            this.schedulerDriver.reconcileTasks((Collection)runningTask.stream().map(each -> Protos.TaskStatus.newBuilder().setTaskId(Protos.TaskID.newBuilder().setValue(each.getId()).build()).setSlaveId(Protos.SlaveID.newBuilder().setValue(each.getSlaveId()).build()).setState(Protos.TaskState.TASK_RUNNING).build()).collect(Collectors.toList()));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void implicitReconcile() {
        this.lock.lock();
        try {
            this.schedulerDriver.reconcileTasks(Collections.emptyList());
        }
        finally {
            this.lock.unlock();
        }
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        FrameworkConfiguration configuration = BootstrapEnvironment.getINSTANCE().getFrameworkConfiguration();
        return AbstractScheduledService.Scheduler.newFixedDelaySchedule((long)configuration.getReconcileIntervalMinutes(), (long)configuration.getReconcileIntervalMinutes(), (TimeUnit)TimeUnit.MINUTES);
    }

    @Generated
    public ReconcileService(SchedulerDriver schedulerDriver, FacadeService facadeService) {
        this.schedulerDriver = schedulerDriver;
        this.facadeService = facadeService;
    }
}

