/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.console.controller;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.cloud.config.CloudJobExecutionType;
import org.apache.shardingsphere.elasticjob.cloud.config.pojo.CloudJobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.cloud.console.controller.search.JobEventRdbSearch;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.config.job.CloudJobConfigurationService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.env.BootstrapEnvironment;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.mesos.FacadeService;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.producer.ProducerManager;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.state.failover.FailoverTaskInfo;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.StatisticManager;
import org.apache.shardingsphere.elasticjob.cloud.statistics.StatisticInterval;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobExecutionTypeStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRegisterStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.job.JobRunningStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskResultStatistics;
import org.apache.shardingsphere.elasticjob.cloud.statistics.type.task.TaskRunningStatistics;
import org.apache.shardingsphere.elasticjob.infra.context.TaskContext;
import org.apache.shardingsphere.elasticjob.infra.exception.JobSystemException;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.restful.RestfulController;
import org.apache.shardingsphere.elasticjob.restful.annotation.ContextPath;
import org.apache.shardingsphere.elasticjob.restful.annotation.Mapping;
import org.apache.shardingsphere.elasticjob.restful.annotation.Param;
import org.apache.shardingsphere.elasticjob.restful.annotation.ParamSource;
import org.apache.shardingsphere.elasticjob.restful.annotation.RequestBody;
import org.apache.shardingsphere.elasticjob.restful.wrapper.QueryParameterMap;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.event.JobExecutionEvent;
import org.apache.shardingsphere.elasticjob.tracing.event.JobStatusTraceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ContextPath(value="/api/job")
public final class CloudJobController
implements RestfulController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudJobController.class);
    private static CoordinatorRegistryCenter regCenter;
    private static JobEventRdbSearch jobEventRdbSearch;
    private static ProducerManager producerManager;
    private final CloudJobConfigurationService configService;
    private final FacadeService facadeService;
    private final StatisticManager statisticManager;

    public CloudJobController() {
        Preconditions.checkNotNull((Object)regCenter);
        this.configService = new CloudJobConfigurationService(regCenter);
        this.facadeService = new FacadeService(regCenter);
        this.statisticManager = StatisticManager.getInstance(regCenter, null);
    }

    public static void init(CoordinatorRegistryCenter regCenter, ProducerManager producerManager) {
        CloudJobController.regCenter = regCenter;
        CloudJobController.producerManager = producerManager;
        Optional<TracingConfiguration<?>> tracingConfiguration = BootstrapEnvironment.getINSTANCE().getTracingConfiguration();
        jobEventRdbSearch = tracingConfiguration.map(tracingConfiguration1 -> new JobEventRdbSearch((DataSource)tracingConfiguration1.getTracingStorageConfiguration().getStorage())).orElse(null);
    }

    @Mapping(method="POST", path="/register")
    public boolean register(@RequestBody CloudJobConfigurationPOJO cloudJobConfig) {
        producerManager.register(cloudJobConfig);
        return true;
    }

    @Mapping(method="PUT", path="/update")
    public boolean update(@RequestBody CloudJobConfigurationPOJO cloudJobConfig) {
        producerManager.update(cloudJobConfig);
        return true;
    }

    @Mapping(method="DELETE", path="/{jobName}/deregister")
    public boolean deregister(@Param(name="jobName", source=ParamSource.PATH) String jobName) {
        producerManager.deregister(jobName);
        return true;
    }

    @Mapping(method="GET", path="/{jobName}/disable")
    public boolean isDisabled(@Param(name="jobName", source=ParamSource.PATH) String jobName) {
        return this.facadeService.isJobDisabled(jobName);
    }

    @Mapping(method="POST", path="/{jobName}/enable")
    public boolean enable(@Param(name="jobName", source=ParamSource.PATH) String jobName) {
        Optional<CloudJobConfigurationPOJO> configOptional = this.configService.load(jobName);
        if (configOptional.isPresent()) {
            this.facadeService.enableJob(jobName);
            producerManager.reschedule(jobName);
        }
        return true;
    }

    @Mapping(method="POST", path="/{jobName}/disable")
    public boolean disable(@Param(name="jobName", source=ParamSource.PATH) String jobName) {
        if (this.configService.load(jobName).isPresent()) {
            this.facadeService.disableJob(jobName);
            producerManager.unschedule(jobName);
        }
        return true;
    }

    @Mapping(method="POST", path="/trigger")
    public boolean trigger(@RequestBody String jobName) {
        Optional<CloudJobConfigurationPOJO> config = this.configService.load(jobName);
        if (config.isPresent() && CloudJobExecutionType.DAEMON == config.get().getJobExecutionType()) {
            throw new JobSystemException("Daemon job '%s' cannot support trigger.", new Object[]{jobName});
        }
        this.facadeService.addTransient(jobName);
        return true;
    }

    @Mapping(method="GET", path="/jobs/{jobName}")
    public CloudJobConfigurationPOJO detail(@Param(name="jobName", source=ParamSource.PATH) String jobName) {
        Optional<CloudJobConfigurationPOJO> cloudJobConfig = this.configService.load(jobName);
        return cloudJobConfig.orElse(null);
    }

    @Mapping(method="GET", path="/jobs")
    public Collection<CloudJobConfigurationPOJO> findAllJobs() {
        return this.configService.loadAll();
    }

    @Mapping(method="GET", path="/tasks/running")
    public Collection<TaskContext> findAllRunningTasks() {
        LinkedList<TaskContext> result = new LinkedList<TaskContext>();
        for (Set<TaskContext> each : this.facadeService.getAllRunningTasks().values()) {
            result.addAll(each);
        }
        return result;
    }

    @Mapping(method="GET", path="/tasks/ready")
    public Collection<Map<String, String>> findAllReadyTasks() {
        Map<String, Integer> readyTasks = this.facadeService.getAllReadyTasks();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(readyTasks.size());
        for (Map.Entry<String, Integer> each : readyTasks.entrySet()) {
            HashMap<String, String> oneTask = new HashMap<String, String>(2, 1.0f);
            oneTask.put("jobName", each.getKey());
            oneTask.put("times", String.valueOf(each.getValue()));
            result.add(oneTask);
        }
        return result;
    }

    @Mapping(method="GET", path="/tasks/failover")
    public Collection<FailoverTaskInfo> findAllFailoverTasks() {
        LinkedList<FailoverTaskInfo> result = new LinkedList<FailoverTaskInfo>();
        for (Collection<FailoverTaskInfo> each : this.facadeService.getAllFailoverTasks().values()) {
            result.addAll(each);
        }
        return result;
    }

    @Mapping(method="GET", path="/events/executions")
    public JobEventRdbSearch.Result<JobExecutionEvent> findJobExecutionEvents(QueryParameterMap requestParams) throws ParseException {
        if (!this.isRdbConfigured()) {
            return new JobEventRdbSearch.Result<JobExecutionEvent>(0, Collections.emptyList());
        }
        return jobEventRdbSearch.findJobExecutionEvents(this.buildCondition(requestParams.toSingleValueMap(), new String[]{"jobName", "taskId", "ip", "isSuccess"}));
    }

    @Mapping(method="GET", path="/events/statusTraces")
    public JobEventRdbSearch.Result<JobStatusTraceEvent> findJobStatusTraceEvents(QueryParameterMap requestParams) throws ParseException {
        if (!this.isRdbConfigured()) {
            return new JobEventRdbSearch.Result<JobStatusTraceEvent>(0, Collections.emptyList());
        }
        return jobEventRdbSearch.findJobStatusTraceEvents(this.buildCondition(requestParams.toSingleValueMap(), new String[]{"jobName", "taskId", "slaveId", "source", "executionType", "state"}));
    }

    private boolean isRdbConfigured() {
        return null != jobEventRdbSearch;
    }

    private JobEventRdbSearch.Condition buildCondition(Map<String, String> requestParams, String[] params) throws ParseException {
        int perPage = 10;
        int page = 1;
        if (!Strings.isNullOrEmpty((String)requestParams.get("per_page"))) {
            perPage = Integer.parseInt(requestParams.get("per_page"));
        }
        if (!Strings.isNullOrEmpty((String)requestParams.get("page"))) {
            page = Integer.parseInt(requestParams.get("page"));
        }
        String sort = requestParams.get("sort");
        String order = requestParams.get("order");
        Date startTime = null;
        Date endTime = null;
        Map<String, Object> fields = this.getQueryParameters(requestParams, params);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (!Strings.isNullOrEmpty((String)requestParams.get("startTime"))) {
            startTime = simpleDateFormat.parse(requestParams.get("startTime"));
        }
        if (!Strings.isNullOrEmpty((String)requestParams.get("endTime"))) {
            endTime = simpleDateFormat.parse(requestParams.get("endTime"));
        }
        return new JobEventRdbSearch.Condition(perPage, page, sort, order, startTime, endTime, fields);
    }

    private Map<String, Object> getQueryParameters(Map<String, String> requestParams, String[] params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String each : params) {
            if (Strings.isNullOrEmpty((String)requestParams.get(each))) continue;
            result.put(each, requestParams.get(each));
        }
        return result;
    }

    @Mapping(method="GET", path="/statistics/tasks/results")
    public List<TaskResultStatistics> findTaskResultStatistics(@Param(name="since", source=ParamSource.QUERY, required=false) String since) {
        if ("last24hours".equals(since)) {
            return this.statisticManager.findTaskResultStatisticsDaily();
        }
        return Collections.emptyList();
    }

    @Mapping(method="GET", path="/statistics/tasks/results/{period}")
    public TaskResultStatistics getTaskResultStatistics(@Param(name="period", source=ParamSource.PATH, required=false) String period) {
        switch (period) {
            case "online": {
                return this.statisticManager.getTaskResultStatisticsSinceOnline();
            }
            case "lastWeek": {
                return this.statisticManager.getTaskResultStatisticsWeekly();
            }
            case "lastHour": {
                return this.statisticManager.findLatestTaskResultStatistics(StatisticInterval.HOUR);
            }
            case "lastMinute": {
                return this.statisticManager.findLatestTaskResultStatistics(StatisticInterval.MINUTE);
            }
        }
        return new TaskResultStatistics(0, 0, StatisticInterval.DAY, new Date());
    }

    @Mapping(method="GET", path="/statistics/tasks/running")
    public List<TaskRunningStatistics> findTaskRunningStatistics(@Param(name="since", source=ParamSource.QUERY, required=false) String since) {
        if ("lastWeek".equals(since)) {
            return this.statisticManager.findTaskRunningStatisticsWeekly();
        }
        return Collections.emptyList();
    }

    @Mapping(method="GET", path="/statistics/jobs/executionType")
    public JobExecutionTypeStatistics getJobExecutionTypeStatistics() {
        return this.statisticManager.getJobExecutionTypeStatistics();
    }

    @Mapping(method="GET", path="/statistics/jobs/running")
    public List<JobRunningStatistics> findJobRunningStatistics(@Param(name="since", source=ParamSource.QUERY, required=false) String since) {
        if ("lastWeek".equals(since)) {
            return this.statisticManager.findJobRunningStatisticsWeekly();
        }
        return Collections.emptyList();
    }

    @Mapping(method="GET", path="/statistics/jobs/register")
    public List<JobRegisterStatistics> findJobRegisterStatistics() {
        return this.statisticManager.findJobRegisterStatisticsSinceOnline();
    }
}

