/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.common.metrics;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.seatunnel.api.common.metrics.Meter;
import org.apache.seatunnel.api.common.metrics.Unit;

public class ThreadSafeQPSMeter
implements Meter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicLongFieldUpdater<ThreadSafeQPSMeter> VOLATILE_VALUE_UPDATER = AtomicLongFieldUpdater.newUpdater(ThreadSafeQPSMeter.class, "value");
    private final String name;
    private volatile long value;
    private final long timestamp;

    public ThreadSafeQPSMeter(String name) {
        this.name = name;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public void markEvent() {
        VOLATILE_VALUE_UPDATER.incrementAndGet(this);
    }

    @Override
    public void markEvent(long n) {
        VOLATILE_VALUE_UPDATER.addAndGet(this, n);
    }

    @Override
    public double getRate() {
        long cost = System.currentTimeMillis() - this.timestamp;
        return (double)this.value * 1000.0 / (double)cost;
    }

    @Override
    public long getCount() {
        return VOLATILE_VALUE_UPDATER.get(this);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Unit unit() {
        return Unit.COUNT;
    }

    public String toString() {
        return "ThreadSafeQPSMeter{name='" + this.name + '\'' + ", value=" + this.value + ", timestamp=" + this.timestamp + '}';
    }
}

