/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dal.dao.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.seatunnel.app.dal.dao.IJobVersionDao;
import org.apache.seatunnel.app.dal.entity.JobVersion;
import org.apache.seatunnel.app.dal.mapper.JobVersionMapper;
import org.springframework.stereotype.Repository;

@Repository
public class JobVersionDaoImpl
implements IJobVersionDao {
    @Resource
    private JobVersionMapper jobVersionMapper;

    @Override
    public void createVersion(JobVersion jobVersion) {
        this.jobVersionMapper.insert(jobVersion);
    }

    @Override
    public void updateVersion(JobVersion version) {
        this.jobVersionMapper.updateById(version);
    }

    @Override
    public JobVersion getLatestVersion(long jobId) {
        HashMap<String, Long> queryMap = new HashMap<String, Long>();
        queryMap.put("job_id", jobId);
        return (JobVersion)this.jobVersionMapper.selectByMap(queryMap).get(0);
    }

    @Override
    public List<JobVersion> getLatestVersionByJobIds(List<Long> jobIds) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"job_id", jobIds);
        return this.jobVersionMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public JobVersion getVersionById(long jobVersionId) {
        return (JobVersion)this.jobVersionMapper.selectById(Long.valueOf(jobVersionId));
    }

    @Override
    public List<JobVersion> getVersionsByIds(List<Long> jobVersionIds) {
        return this.jobVersionMapper.selectBatchIds(jobVersionIds);
    }
}

