/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.Addresses;
import com.hazelcast.client.util.AddressHelper;
import com.hazelcast.cluster.Address;
import java.util.List;

public class DefaultAddressProvider
implements AddressProvider {
    private final ClientNetworkConfig networkConfig;

    public DefaultAddressProvider(ClientNetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
    }

    @Override
    public Addresses loadAddresses() {
        List<String> configuredAddresses = this.networkConfig.getAddresses();
        if (configuredAddresses.isEmpty()) {
            configuredAddresses.add("127.0.0.1");
        }
        Addresses addresses = new Addresses();
        for (String address : configuredAddresses) {
            addresses.addAll(AddressHelper.getSocketAddresses(address));
        }
        return addresses;
    }

    @Override
    public Address translate(Address address) {
        return address;
    }
}

