/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.nlpmodel.embedding.remote;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.seatunnel.common.utils.BufferUtils;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.seatunnel.transform.nlpmodel.embedding.remote.Model;

public abstract class AbstractModel
implements Model {
    protected static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected static final String DIMENSION_EXAMPLE = "dimension example";
    private final Integer singleVectorizedInputNumber;

    protected AbstractModel(Integer singleVectorizedInputNumber) {
        this.singleVectorizedInputNumber = singleVectorizedInputNumber;
    }

    @Override
    public List<ByteBuffer> vectorization(Object[] fields) throws IOException {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        List<List<Float>> vectors = this.batchProcess(fields, this.singleVectorizedInputNumber);
        for (List<Float> vector : vectors) {
            result.add(BufferUtils.toByteBuffer((Float[])vector.toArray(new Float[0])));
        }
        return result;
    }

    protected abstract List<List<Float>> vector(Object[] var1) throws IOException;

    public List<List<Float>> batchProcess(Object[] array, int batchSize) throws IOException {
        ArrayList<List<Float>> merged = new ArrayList<List<Float>>();
        if (array == null || array.length == 0) {
            return merged;
        }
        for (int i = 0; i < array.length; i += batchSize) {
            Object[] batch = ArrayUtils.subarray((Object[])array, (int)i, (int)(i + batchSize));
            List<List<Float>> vector = this.vector(batch);
            merged.addAll(vector);
        }
        if (array.length != merged.size()) {
            throw new RuntimeException("The number of vectors is not equal to the number of inputs, Please verify the configuration of the input field and the result returned.");
        }
        return merged;
    }
}

