/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.abc.diagnostics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.royale.abc.graph.IBasicBlock;
import org.apache.royale.abc.graph.IFlowgraph;
import org.apache.royale.abc.semantics.MethodBodyInfo;
import org.apache.royale.abc.semantics.MethodInfo;
import org.apache.royale.abc.semantics.ScriptInfo;
import org.apache.royale.abc.visitors.IDiagnosticsVisitor;

public class DiagnosticsAggregator
implements IDiagnosticsVisitor {
    private final List<ProblemDescription> errors = new ArrayList<ProblemDescription>();
    private final List<ProblemDescription> warnings = new ArrayList<ProblemDescription>();

    public List<ProblemDescription> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List<ProblemDescription> getWarnings() {
        return Collections.unmodifiableList(this.warnings);
    }

    @Override
    public void operandStackUnderflow(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block, int instructionIndex) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.OperandStackUnderflow, cfg, block, instructionIndex));
    }

    @Override
    public void scopeStackUnderflow(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block, int instructionIndex) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.ScopeStackUnderflow, cfg, block, instructionIndex));
    }

    @Override
    public void unreachableBlock(MethodBodyInfo methodBodyInfo, IFlowgraph cfg, IBasicBlock block) {
        this.warnings.add(new ProblemDescription(ProblemDescription.ProblemType.UnreachableBlock, cfg, block, block.size() - 1));
    }

    @Override
    public void tooManyDefaultParameters(MethodInfo methodInfo) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.TooManyDefaultParameters, methodInfo));
    }

    @Override
    public void incorrectNumberOfParameterNames(MethodInfo methodInfo) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.IncorrectNumberOfParameterNames, methodInfo));
    }

    @Override
    public void nativeMethodWithMethodBody(MethodInfo methodInfo, MethodBodyInfo methodBodyInfo) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.NativeMethodWithMethodBody, methodInfo));
    }

    @Override
    public void scriptInitWithRequiredArguments(ScriptInfo scriptInfo, MethodInfo methodInfo) {
        this.errors.add(new ProblemDescription(ProblemDescription.ProblemType.ScriptInitWithRequiredArguments, scriptInfo, methodInfo));
    }

    public static class ProblemDescription {
        public final ProblemType problemType;
        public final String sourcePath;
        public final int lineNumber;
        public final MethodInfo methodInfo;
        public final ScriptInfo scriptInfo;

        private ProblemDescription(ProblemType problemType, IFlowgraph cfg, IBasicBlock b, int offset) {
            switch (problemType) {
                case OperandStackUnderflow: 
                case ScopeStackUnderflow: 
                case UnreachableBlock: {
                    this.problemType = problemType;
                    this.sourcePath = cfg.findSourcePath(b, offset);
                    this.lineNumber = cfg.findLineNumber(b, offset);
                    this.methodInfo = null;
                    this.scriptInfo = null;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid problem type %s", new Object[]{problemType}));
                }
            }
        }

        private ProblemDescription(ProblemType problemType, MethodInfo methodInfo) {
            switch (problemType) {
                case TooManyDefaultParameters: 
                case IncorrectNumberOfParameterNames: 
                case NativeMethodWithMethodBody: {
                    this.problemType = problemType;
                    this.methodInfo = methodInfo;
                    this.scriptInfo = null;
                    this.sourcePath = null;
                    this.lineNumber = -1;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid problem type %s", new Object[]{problemType}));
                }
            }
        }

        private ProblemDescription(ProblemType problemType, ScriptInfo scriptInfo, MethodInfo methodInfo) {
            switch (problemType) {
                case ScriptInitWithRequiredArguments: {
                    this.problemType = problemType;
                    this.methodInfo = methodInfo;
                    this.scriptInfo = scriptInfo;
                    this.sourcePath = null;
                    this.lineNumber = -1;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Invalid problem type %s", new Object[]{problemType}));
                }
            }
        }

        public static enum ProblemType {
            OperandStackUnderflow,
            ScopeStackUnderflow,
            UnreachableBlock,
            TooManyDefaultParameters,
            IncorrectNumberOfParameterNames,
            NativeMethodWithMethodBody,
            ScriptInitWithRequiredArguments;

        }
    }
}

