/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.linter.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.royale.compiler.common.ISourceLocation;
import org.apache.royale.compiler.problems.CompilerProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.as.IPackageNode;
import org.apache.royale.linter.LinterRule;
import org.apache.royale.linter.NodeVisitor;
import org.apache.royale.linter.TokenQuery;
import org.apache.royale.linter.problems.ILinterProblem;

public class PackageNameRule
extends LinterRule {
    public static final Pattern DEFAULT_NAME_PATTERN = Pattern.compile("^[a-z][a-zA-Z0-9]*(\\.[a-z][a-zA-Z0-9]*)*$");
    public Pattern pattern;

    @Override
    public Map<ASTNodeID, NodeVisitor> getNodeVisitors() {
        HashMap<ASTNodeID, NodeVisitor> result = new HashMap<ASTNodeID, NodeVisitor>();
        result.put(ASTNodeID.PackageID, (node, tokenQuery, problems) -> this.checkPackageNode((IPackageNode)node, tokenQuery, problems));
        return result;
    }

    private void checkPackageNode(IPackageNode packageNode, TokenQuery tokenQuery, Collection<ICompilerProblem> problems) {
        Matcher matcher;
        String packageName = packageNode.getName();
        if (packageName.length() == 0) {
            return;
        }
        Pattern thePattern = this.pattern;
        if (thePattern == null) {
            thePattern = DEFAULT_NAME_PATTERN;
        }
        if ((matcher = thePattern.matcher(packageName)).matches()) {
            return;
        }
        problems.add(new PackageNameLinterProblem(packageNode, thePattern));
    }

    public static class PackageNameLinterProblem
    extends CompilerProblem
    implements ILinterProblem {
        public static final String DESCRIPTION = "Package name '${packageName}' does not match the pattern '${pattern}'";
        public String pattern;
        public String packageName;

        public PackageNameLinterProblem(IPackageNode node, Pattern pattern) {
            super((ISourceLocation)node);
            this.pattern = pattern.toString();
            this.packageName = node.getName();
        }
    }
}

