/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.mimecontentconverter.ConversionUtils;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentConverterRegistry;
import org.apache.qpid.server.message.mimecontentconverter.ObjectToMimeContentConverter;
import org.apache.qpid.server.protocol.converter.MessageConversionException;
import org.apache.qpid.server.protocol.v1_0.JmsMessageTypeAnnotation;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_v1_0_to_Internal;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.messaging.SectionDecoderImpl;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedByte;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedShort;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpSequenceSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.AmqpValueSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.DataSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.EncodingRetainingSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Header;
import org.apache.qpid.server.protocol.v1_0.type.messaging.HeaderSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.MessageAnnotationsSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Properties;
import org.apache.qpid.server.protocol.v1_0.type.messaging.PropertiesSection;
import org.apache.qpid.server.protocol.v1_0.type.messaging.codec.EncodingRetaining;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.apache.qpid.server.util.ServerScopedRuntimeException;

public class MessageConverter_from_1_0 {
    private static final Set<Class> STANDARD_TYPES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, String.class, byte[].class, UUID.class, Date.class));

    static Object convertBodyToObject(Message_1_0 serverMessage) {
        SectionDecoderImpl sectionDecoder = new SectionDecoderImpl(MessageConverter_v1_0_to_Internal.TYPE_REGISTRY.getSectionDecoderRegistry());
        Object bodyObject = null;
        List<EncodingRetainingSection<?>> sections = null;
        try {
            try (QpidByteBuffer allData = serverMessage.getContent();){
                sections = sectionDecoder.parseAll(allData);
            }
            int size = sections == null ? 0 : sections.size();
            ArrayList<EncodingRetainingSection> bodySections = new ArrayList<EncodingRetainingSection>(size);
            ListIterator<Object> iterator = sections == null ? Collections.emptyListIterator() : sections.listIterator();
            Object previousSection = null;
            while (iterator.hasNext()) {
                EncodingRetainingSection section = (EncodingRetainingSection)iterator.next();
                if (!(section instanceof AmqpValueSection) && !(section instanceof DataSection) && !(section instanceof AmqpSequenceSection)) continue;
                if (previousSection != null && (previousSection.getClass() != section.getClass() || section instanceof AmqpValueSection)) {
                    throw new MessageConversionException("Message is badly formed and has multiple body section which are not all Data or not all AmqpSequence");
                }
                previousSection = section;
                bodySections.add(section);
            }
            if (!bodySections.isEmpty()) {
                EncodingRetainingSection firstBodySection = (EncodingRetainingSection)bodySections.get(0);
                if (firstBodySection instanceof AmqpValueSection) {
                    bodyObject = MessageConverter_from_1_0.convertValue(firstBodySection.getValue());
                } else if (firstBodySection instanceof DataSection) {
                    int totalSize = 0;
                    for (EncodingRetainingSection section : bodySections) {
                        totalSize += ((Binary)((DataSection)section).getValue()).getArray().length;
                    }
                    byte[] bodyData = new byte[totalSize];
                    ByteBuffer buf = ByteBuffer.wrap(bodyData);
                    for (EncodingRetainingSection section : bodySections) {
                        buf.put(((Binary)((DataSection)section).getValue()).asByteBuffer());
                    }
                    bodyObject = bodyData;
                } else {
                    ArrayList totalSequence = new ArrayList();
                    for (EncodingRetainingSection section : bodySections) {
                        totalSequence.addAll((Collection)((AmqpSequenceSection)section).getValue());
                    }
                    bodyObject = MessageConverter_from_1_0.convertValue(totalSequence);
                }
            }
        }
        catch (AmqpErrorException e) {
            throw new ConnectionScopedRuntimeException((Throwable)e);
        }
        finally {
            if (sections != null) {
                sections.forEach(EncodingRetaining::dispose);
            }
        }
        return bodyObject;
    }

    private static Map<Object, Object> convertMap(Map<Object, Object> map) {
        LinkedHashMap<Object, Object> resultMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            resultMap.put(MessageConverter_from_1_0.convertValue(entry.getKey()), MessageConverter_from_1_0.convertValue(entry.getValue()));
        }
        return resultMap;
    }

    public static Object convertValue(Object value) {
        if (value != null && !STANDARD_TYPES.contains(value.getClass())) {
            if (value instanceof Map) {
                return MessageConverter_from_1_0.convertMap((Map)value);
            }
            if (value instanceof List) {
                return MessageConverter_from_1_0.convertList((List)value);
            }
            if (value instanceof UnsignedByte) {
                return ((UnsignedByte)value).shortValue();
            }
            if (value instanceof UnsignedShort) {
                return ((UnsignedShort)value).intValue();
            }
            if (value instanceof UnsignedInteger) {
                return ((UnsignedInteger)value).longValue();
            }
            if (value instanceof UnsignedLong) {
                return ((UnsignedLong)value).longValue();
            }
            if (value instanceof Symbol) {
                return value.toString();
            }
            if (value instanceof Binary) {
                return ((Binary)value).getArray();
            }
            throw new MessageConversionException(String.format("Could not convert message from 1.0. Unsupported type '%s'.", value.getClass().getSimpleName()));
        }
        return value;
    }

    private static List<Object> convertList(List<Object> list) {
        ArrayList<Object> result = new ArrayList<Object>(list.size());
        for (Object entry : list) {
            result.add(MessageConverter_from_1_0.convertValue(entry));
        }
        return result;
    }

    private static ContentHint getAmqp0xTypeHint(Message_1_0 serverMsg) {
        Symbol contentType = MessageConverter_from_1_0.getContentType(serverMsg);
        JmsMessageTypeAnnotation jmsMessageTypeAnnotation = MessageConverter_from_1_0.getJmsMessageTypeAnnotation(serverMsg);
        String mimeTypeHint = null;
        Class<Object> classHint = MessageConverter_from_1_0.getContentTypeClassHint(jmsMessageTypeAnnotation);
        if (contentType != null) {
            Class contentTypeClassHint = null;
            String type = contentType.toString();
            String supportedContentType = null;
            if (ConversionUtils.TEXT_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = String.class;
                supportedContentType = "text/plain";
            } else if (ConversionUtils.MAP_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = Map.class;
                supportedContentType = contentType.toString();
            } else if (ConversionUtils.LIST_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = List.class;
                supportedContentType = contentType.toString();
            } else if (ConversionUtils.OBJECT_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = Serializable.class;
                supportedContentType = "application/java-object-stream";
            } else if (ConversionUtils.BYTES_MESSAGE_CONTENT_TYPES.matcher(type).matches()) {
                contentTypeClassHint = byte[].class;
                supportedContentType = "application/octet-stream";
            }
            if (classHint == null || classHint == contentTypeClassHint) {
                classHint = contentTypeClassHint;
                mimeTypeHint = supportedContentType;
            }
        }
        return new ContentHint(classHint, mimeTypeHint);
    }

    static Class<?> getContentTypeClassHint(JmsMessageTypeAnnotation jmsMessageTypeAnnotation) {
        Class classHint = null;
        if (jmsMessageTypeAnnotation != null) {
            switch (jmsMessageTypeAnnotation) {
                case MESSAGE: {
                    classHint = Void.class;
                    break;
                }
                case MAP_MESSAGE: {
                    classHint = Map.class;
                    break;
                }
                case BYTES_MESSAGE: {
                    classHint = byte[].class;
                    break;
                }
                case OBJECT_MESSAGE: {
                    classHint = Serializable.class;
                    break;
                }
                case TEXT_MESSAGE: {
                    classHint = String.class;
                    break;
                }
                case STREAM_MESSAGE: {
                    classHint = List.class;
                    break;
                }
                default: {
                    throw new ServerScopedRuntimeException(String.format("Unexpected jms message type annotation %s", new Object[]{jmsMessageTypeAnnotation}));
                }
            }
        }
        return classHint;
    }

    static JmsMessageTypeAnnotation getJmsMessageTypeAnnotation(Message_1_0 serverMsg) {
        JmsMessageTypeAnnotation jmsMessageTypeAnnotation = null;
        MessageAnnotationsSection section = serverMsg.getMessageAnnotationsSection();
        if (section != null) {
            Object object;
            Map annotations = (Map)section.getValue();
            section.dispose();
            if (annotations != null && annotations.containsKey(JmsMessageTypeAnnotation.ANNOTATION_KEY) && (object = annotations.get(JmsMessageTypeAnnotation.ANNOTATION_KEY)) instanceof Byte) {
                try {
                    jmsMessageTypeAnnotation = JmsMessageTypeAnnotation.valueOf((Byte)object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return jmsMessageTypeAnnotation;
    }

    public static Symbol getContentType(Message_1_0 serverMsg) {
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                return properties.getContentType();
            }
        }
        return null;
    }

    public static UnsignedInteger getGroupSequence(Message_1_0 serverMsg) {
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                return properties.getGroupSequence();
            }
        }
        return null;
    }

    public static String getGroupId(Message_1_0 serverMsg) {
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                return properties.getGroupId();
            }
        }
        return null;
    }

    public static Date getCreationTime(Message_1_0 serverMsg) {
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                return properties.getCreationTime();
            }
        }
        return null;
    }

    public static Date getAbsoluteExpiryTime(Message_1_0 serverMsg) {
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                return properties.getAbsoluteExpiryTime();
            }
        }
        return null;
    }

    public static Long getTtl(Message_1_0 serverMsg) {
        HeaderSection headerSection = serverMsg.getHeaderSection();
        if (headerSection != null) {
            UnsignedInteger ttl;
            Header header = (Header)headerSection.getValue();
            headerSection.dispose();
            if (header != null && (ttl = header.getTtl()) != null) {
                return ttl.longValue();
            }
        }
        return null;
    }

    public static Binary getUserId(Message_1_0 serverMsg) {
        Binary userId = null;
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                userId = properties.getUserId();
            }
        }
        return userId;
    }

    public static String getReplyTo(Message_1_0 serverMsg) {
        String replyTo = null;
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                replyTo = properties.getReplyTo();
            }
        }
        return replyTo;
    }

    static Symbol getContentEncoding(Message_1_0 serverMsg) {
        Symbol contentEncoding = null;
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                contentEncoding = properties.getContentEncoding();
            }
        }
        return contentEncoding;
    }

    public static Object getCorrelationId(Message_1_0 serverMsg) {
        Object correlationIdObject = null;
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                correlationIdObject = properties.getCorrelationId();
            }
        }
        return correlationIdObject;
    }

    public static Object getMessageId(Message_1_0 serverMsg) {
        Object messageId = null;
        PropertiesSection propertiesSection = serverMsg.getPropertiesSection();
        if (propertiesSection != null) {
            Properties properties = (Properties)propertiesSection.getValue();
            propertiesSection.dispose();
            if (properties != null) {
                messageId = properties.getMessageId();
            }
        }
        return messageId;
    }

    public static ConvertedContentAndMimeType getAmqp0xConvertedContentAndMimeType(Message_1_0 serverMsg) {
        Object bodyObject = MessageConverter_from_1_0.convertBodyToObject(serverMsg);
        ObjectToMimeContentConverter converter = MimeContentConverterRegistry.getBestFitObjectToMimeContentConverter((Object)bodyObject);
        ContentHint contentHint = MessageConverter_from_1_0.getAmqp0xTypeHint(serverMsg);
        Class<Object> typeHint = contentHint.getContentClass();
        if (typeHint == null && bodyObject == null) {
            typeHint = Void.class;
        }
        if (converter == null && (converter = MimeContentConverterRegistry.getBestFitObjectToMimeContentConverter((Object)bodyObject, typeHint)) == null) {
            throw new MessageConversionException(String.format("Could not convert message from 1.0 to 0-x because conversion of content failed. Could not find mime type converter for the content '%s'.", bodyObject == null ? null : bodyObject.getClass().getSimpleName()));
        }
        byte[] messageContent = converter.toMimeContent(bodyObject);
        String mimeType = converter.getMimeType();
        if (bodyObject instanceof byte[]) {
            if (Serializable.class == typeHint) {
                mimeType = "application/java-object-stream";
            } else if (String.class == typeHint) {
                mimeType = "text/plain";
            } else if ((Map.class == typeHint || List.class == typeHint) && contentHint.getContentType() != null) {
                mimeType = contentHint.getContentType();
            }
        }
        return new ConvertedContentAndMimeType(messageContent, mimeType);
    }

    public static class ContentHint {
        private final Class<?> _contentClass;
        private final String _contentType;

        ContentHint(Class<?> contentClass, String contentType) {
            this._contentClass = contentClass;
            this._contentType = contentType;
        }

        Class<?> getContentClass() {
            return this._contentClass;
        }

        public String getContentType() {
            return this._contentType;
        }
    }

    public static class ConvertedContentAndMimeType {
        private final byte[] _content;
        private final String _mimeType;

        private ConvertedContentAndMimeType(byte[] content, String mimeType) {
            this._content = content;
            this._mimeType = mimeType;
        }

        public byte[] getContent() {
            return this._content;
        }

        public String getMimeType() {
            return this._mimeType;
        }
    }
}

