/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.util.StateChangeListener;

public final class StateChangeListenerEntry<T, E> {
    private static final AtomicReferenceFieldUpdater<StateChangeListenerEntry, StateChangeListenerEntry> NEXT = AtomicReferenceFieldUpdater.newUpdater(StateChangeListenerEntry.class, StateChangeListenerEntry.class, "_next");
    private volatile StateChangeListenerEntry<T, E> _next;
    private volatile StateChangeListener<T, E> _listener;

    public StateChangeListenerEntry(StateChangeListener<T, E> listener) {
        this._listener = listener;
    }

    public StateChangeListener<T, E> getListener() {
        return this._listener;
    }

    public StateChangeListenerEntry<T, E> next() {
        return NEXT.get(this);
    }

    private boolean append(StateChangeListenerEntry<T, E> entry) {
        return NEXT.compareAndSet(this, null, entry);
    }

    public void add(StateChangeListener<T, E> listener) {
        this.add(new StateChangeListenerEntry<T, E>(listener));
    }

    public void add(StateChangeListenerEntry<T, E> entry) {
        StateChangeListenerEntry<T, E> tail = this;
        while (!entry.getListener().equals(tail.getListener()) && !tail.append(entry)) {
            tail = tail.next();
        }
    }

    public boolean remove(StateChangeListener<T, E> listener) {
        if (listener.equals(this._listener)) {
            this._listener = null;
            return true;
        }
        StateChangeListenerEntry<T, E> next = this.next();
        if (next != null) {
            StateChangeListenerEntry<T, E> nextButOne;
            boolean returnVal = next.remove(listener);
            if (next._listener == null && (nextButOne = next.next()) != null) {
                NEXT.compareAndSet(this, next, nextButOne);
            }
            return returnVal;
        }
        return false;
    }
}

