/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import org.apache.qpid.server.model.PasswordCredentialManagingAuthenticationProvider;
import org.apache.qpid.server.security.auth.sasl.PasswordSource;
import org.apache.qpid.server.security.auth.sasl.crammd5.AbstractCramMd5Negotiator;

public class CramMd5HexNegotiator
extends AbstractCramMd5Negotiator {
    public static final String MECHANISM = "CRAM-MD5-HEX";
    private static final AbstractCramMd5Negotiator.PasswordTransformer HEX_PASSWORD_TRANSFORMER = password -> {
        StringBuilder sb = new StringBuilder();
        for (char c : password) {
            if ((byte)c > -1 && (byte)c < 16) {
                sb.append(0);
            }
            sb.append(Integer.toHexString(c & 0xFF));
        }
        char[] hex = new char[sb.length()];
        sb.getChars(0, sb.length(), hex, 0);
        return hex;
    };

    public CramMd5HexNegotiator(PasswordCredentialManagingAuthenticationProvider<?> authenticationProvider, String localFQDN, PasswordSource passwordSource) {
        super(authenticationProvider, localFQDN, passwordSource, HEX_PASSWORD_TRANSFORMER);
    }
}

