/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.store;

import java.util.Collection;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Model;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.store.DurableConfigurationStore;

public class StoreConfigurationChangeListener
implements ConfigurationChangeListener {
    private final DurableConfigurationStore _store;
    private boolean _bulkChanges = false;

    public StoreConfigurationChangeListener(DurableConfigurationStore store) {
        this._store = store;
    }

    public void stateChanged(ConfiguredObject object, State oldState, State newState) {
        if (newState == State.DELETED) {
            if (object.isDurable()) {
                this._store.remove(object.asObjectRecord());
            }
            object.removeChangeListener(this);
        }
    }

    @Override
    public void childAdded(ConfiguredObject<?> object, ConfiguredObject<?> child) {
        Model model;
        Class<? extends ConfiguredObject> parentType;
        if (!object.managesChildStorage() && object.isDurable() && child.isDurable() && (parentType = (model = child.getModel()).getParentType(child.getCategoryClass())).equals(object.getCategoryClass())) {
            child.addChangeListener(this);
            this._store.update(true, child.asObjectRecord());
            Class<ConfiguredObject> categoryClass = child.getCategoryClass();
            Collection<Class<? extends ConfiguredObject>> childTypes = model.getChildTypes(categoryClass);
            for (Class<? extends ConfiguredObject> childClass : childTypes) {
                for (ConfiguredObject configuredObject : child.getChildren(childClass)) {
                    this.childAdded(child, configuredObject);
                }
            }
        }
    }

    @Override
    public void bulkChangeStart(ConfiguredObject<?> object) {
        this._bulkChanges = true;
    }

    @Override
    public void bulkChangeEnd(ConfiguredObject<?> object) {
        if (object.isDurable() && this._bulkChanges) {
            this._store.update(false, object.asObjectRecord());
        }
        this._bulkChanges = false;
    }

    public void childRemoved(ConfiguredObject object, ConfiguredObject child) {
        if (!object.managesChildStorage()) {
            if (child.isDurable()) {
                this._store.remove(child.asObjectRecord());
            }
            child.removeChangeListener(this);
        }
    }

    public void attributeSet(ConfiguredObject object, String attributeName, Object oldAttributeValue, Object newAttributeValue) {
        if (object.isDurable() && !this._bulkChanges) {
            this._store.update(false, object.asObjectRecord());
        }
    }

    public String toString() {
        return "StoreConfigurationChangeListener [store=" + String.valueOf(this._store) + "]";
    }
}

