/* ConfiguredObjectFilterParser.java */
/* Generated By:JavaCC: Do not edit this line. ConfiguredObjectFilterParser.java */
/*
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 */

package org.apache.qpid.server.management.plugin.servlet.query;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Collections;

import org.apache.qpid.server.filter.ArithmeticExpression;
import org.apache.qpid.server.filter.BooleanExpression;
import org.apache.qpid.server.filter.ComparisonExpression;
import org.apache.qpid.server.filter.ConstantExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.OrderByExpression;
import org.apache.qpid.server.filter.LogicExpression;
import org.apache.qpid.server.filter.UnaryExpression;
import org.apache.qpid.server.filter.NamedExpression;

import org.apache.qpid.server.model.ConfiguredObject;

/**
 * JMS Selector Parser generated by JavaCC
 *
 * Do not edit this .java file directly - it is autogenerated from ConfiguredObjectFilterParser.jj
 */
public class ConfiguredObjectFilterParser<E extends ConfiguredObject<?>> implements ConfiguredObjectFilterParserConstants {
    private ConfiguredObjectExpressionFactory _factory;

    public ConfiguredObjectFilterParser()
    {
        this(new StringReader(""));
    }

    public void setConfiguredObjectExpressionFactory(ConfiguredObjectExpressionFactory factory)
    {
        _factory = factory;
    }

    public BooleanExpression<E> parseWhere(String sql) throws ParseException
    {
        this.ReInit(new StringReader(sql));

        return filter();

    }


    public List<Map<String,Expression>> parseSelect(String sql) throws ParseException
    {
        this.ReInit(new StringReader(sql));

        return selectClause();

    }

    public List<OrderByExpression<E>> parseOrderBy(String sql) throws ParseException
    {
        this.ReInit(new StringReader(sql));

        return orderByClause();
    }

    private BooleanExpression<E> asBooleanExpression(Expression<E> value) throws ParseException
    {
        if (value instanceof BooleanExpression)
        {
            return (BooleanExpression<E>) value;
        }
        if (value instanceof ConfiguredObjectExpression)
        {
            return UnaryExpression.createBooleanCast(value);
        }
        throw new ParseException("Expression will not result in a boolean value: " + value);
    }

// ----------------------------------------------------------------------------
// Grammar
// ----------------------------------------------------------------------------
  final public BooleanExpression<E> filter() throws ParseException {Expression<E> left=null;
    left = orExpression();
    jj_consume_token(0);
{if ("" != null) return asBooleanExpression(left);}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> orExpression() throws ParseException {Expression<E> left;
    Expression<E> right;
    left = andExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        break label_1;
      }
      jj_consume_token(OR);
      right = andExpression();
left = LogicExpression.createOR(asBooleanExpression(left), asBooleanExpression(right));
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> andExpression() throws ParseException {Expression<E> left;
    Expression<E> right;
    left = equalityExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        break label_2;
      }
      jj_consume_token(AND);
      right = equalityExpression();
left = LogicExpression.createAND(asBooleanExpression(left), asBooleanExpression(right));
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> equalityExpression() throws ParseException {Expression<E> left;
    Expression<E> right;
    left = comparisonExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IS:
      case 31:
      case 32:{
        ;
        break;
        }
      default:
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 31:{
        jj_consume_token(31);
        right = comparisonExpression();
left = ComparisonExpression.createEqual(left, right);
        break;
        }
      case 32:{
        jj_consume_token(32);
        right = comparisonExpression();
left = ComparisonExpression.createNotEqual(left, right);
        break;
        }
      default:
        if (jj_2_1(2)) {
          jj_consume_token(IS);
          jj_consume_token(NULL);
left = ComparisonExpression.createIsNull(left);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case IS:{
            jj_consume_token(IS);
            jj_consume_token(NOT);
            jj_consume_token(NULL);
left = ComparisonExpression.createIsNotNull(left);
            break;
            }
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> comparisonExpression() throws ParseException {Expression<E> left;
    Expression<E> right;
    Expression<E> low;
    Expression<E> high;
    String t, u;
        boolean not;
        ArrayList<Expression> list;
    left = addExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case BETWEEN:
      case LIKE:
      case IN:
      case 33:
      case 34:
      case 35:
      case 36:{
        ;
        break;
        }
      default:
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 33:{
        jj_consume_token(33);
        right = addExpression();
left = ComparisonExpression.createGreaterThan(left, right);
        break;
        }
      case 34:{
        jj_consume_token(34);
        right = addExpression();
left = ComparisonExpression.createGreaterThanEqual(left, right);
        break;
        }
      case 35:{
        jj_consume_token(35);
        right = addExpression();
left = ComparisonExpression.createLessThan(left, right);
        break;
        }
      case 36:{
        jj_consume_token(36);
        right = addExpression();
left = ComparisonExpression.createLessThanEqual(left, right);
        break;
        }
      case LIKE:{
u=null;
        jj_consume_token(LIKE);
        t = stringLiteral();
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ESCAPE:{
          jj_consume_token(ESCAPE);
          u = stringLiteral();
          break;
          }
        default:
          ;
        }
left = ComparisonExpression.createLike(left, t, u);
        break;
        }
      default:
        if (jj_2_2(2)) {
u=null;
          jj_consume_token(NOT);
          jj_consume_token(LIKE);
          t = stringLiteral();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case ESCAPE:{
            jj_consume_token(ESCAPE);
            u = stringLiteral();
            break;
            }
          default:
            ;
          }
left = ComparisonExpression.createNotLike(left, t, u);
        } else {
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case BETWEEN:{
            jj_consume_token(BETWEEN);
            low = addExpression();
            jj_consume_token(AND);
            high = addExpression();
left = ComparisonExpression.createBetween(left, low, high);
            break;
            }
          default:
            if (jj_2_3(2)) {
              jj_consume_token(NOT);
              jj_consume_token(BETWEEN);
              low = addExpression();
              jj_consume_token(AND);
              high = addExpression();
left = ComparisonExpression.createNotBetween(left, low, high);
            } else {
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case IN:{
                jj_consume_token(IN);
                jj_consume_token(37);
                right = primaryExpr();
list = new ArrayList<>();
                                    list.add( right );
                label_5:
                while (true) {
                  switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                  case 38:{
                    ;
                    break;
                    }
                  default:
                    break label_5;
                  }
                  jj_consume_token(38);
                  right = primaryExpr();
list.add( right );
                }
                jj_consume_token(39);
left = ComparisonExpression.createInFilter(left, list, true );
                break;
                }
              default:
                if (jj_2_4(2)) {
                  jj_consume_token(NOT);
                  jj_consume_token(IN);
                  jj_consume_token(37);
                  right = primaryExpr();
list = new ArrayList<>();
                                    list.add( right );
                  label_6:
                  while (true) {
                    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                    case 38:{
                      ;
                      break;
                      }
                    default:
                      break label_6;
                    }
                    jj_consume_token(38);
                    right = primaryExpr();
list.add( right );
                  }
                  jj_consume_token(39);
left = ComparisonExpression.createNotInFilter(left, list, true);
                } else {
                  jj_consume_token(-1);
                  throw new ParseException();
                }
              }
            }
          }
        }
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> addExpression() throws ParseException {Expression<E> left;
    Expression<E> right;
    left = multExpr();
    label_7:
    while (true) {
      if (jj_2_5(2147483647)) {
        ;
      } else {
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 40:{
        jj_consume_token(40);
        right = multExpr();
left = ArithmeticExpression.createPlus(left, right);
        break;
        }
      case 41:{
        jj_consume_token(41);
        right = multExpr();
left = ArithmeticExpression.createMinus(left, right);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> multExpr() throws ParseException {Expression<E> left;
    Expression<E> right;
    left = unaryExpr();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 42:
      case 43:
      case 44:{
        ;
        break;
        }
      default:
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 42:{
        jj_consume_token(42);
        right = unaryExpr();
left = ArithmeticExpression.createMultiply(left, right);
        break;
        }
      case 43:{
        jj_consume_token(43);
        right = unaryExpr();
left = ArithmeticExpression.createDivide(left, right);
        break;
        }
      case 44:{
        jj_consume_token(44);
        right = unaryExpr();
left = ArithmeticExpression.createMod(left, right);
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> unaryExpr() throws ParseException {String s=null;
    Expression<E> left=null;
    if (jj_2_6(2147483647)) {
      jj_consume_token(40);
      left = unaryExpr();
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 41:{
        jj_consume_token(41);
        left = unaryExpr();
left = UnaryExpression.createNegate(left);
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        left = unaryExpr();
left = UnaryExpression.createNOT( asBooleanExpression(left) );
        break;
        }
      case TRUE:
      case FALSE:
      case NULL:
      case DECIMAL_LITERAL:
      case HEX_LITERAL:
      case OCTAL_LITERAL:
      case FLOATING_POINT_LITERAL:
      case STRING_LITERAL:
      case FUNCTIONNAME:
      case ID:
      case QUOTED_ID:
      case 37:{
        left = primaryExpr();
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public Expression<E> primaryExpr() throws ParseException {Expression<E> left=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FUNCTIONNAME:{
      left = functionExpression();
      break;
      }
    case TRUE:
    case FALSE:
    case NULL:
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:{
      left = literal();
      break;
      }
    case ID:
    case QUOTED_ID:{
      left = variable();
      break;
      }
    case 37:{
      jj_consume_token(37);
      left = orExpression();
      jj_consume_token(39);
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public ConstantExpression<E> literal() throws ParseException {Token t;
    String s;
    ConstantExpression<E> left=null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_LITERAL:{
      s = stringLiteral();
left = new ConstantExpression<>(s);
      break;
      }
    case DECIMAL_LITERAL:{
      t = jj_consume_token(DECIMAL_LITERAL);
left = ConstantExpression.createFromDecimal(t.image);
      break;
      }
    case HEX_LITERAL:{
      t = jj_consume_token(HEX_LITERAL);
left = ConstantExpression.createFromHex(t.image);
      break;
      }
    case OCTAL_LITERAL:{
      t = jj_consume_token(OCTAL_LITERAL);
left = ConstantExpression.createFromOctal(t.image);
      break;
      }
    case FLOATING_POINT_LITERAL:{
      t = jj_consume_token(FLOATING_POINT_LITERAL);
left = ConstantExpression.createFloat(t.image);
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
left = ConstantExpression.TRUE;
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
left = ConstantExpression.FALSE;
      break;
      }
    case NULL:{
      jj_consume_token(NULL);
left = ConstantExpression.NULL;
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return left;}
    throw new Error("Missing return statement in function");
}

  final public String stringLiteral() throws ParseException {Token t;
    StringBuffer rc = new StringBuffer();
    boolean first=true;
    t = jj_consume_token(STRING_LITERAL);
// Decode the sting value.
        String image = t.image;
        for( int i=1; i < image.length()-1; i++ ) {
            char c = image.charAt(i);
            if( c == (char) 0x27 )//single quote
            {
                i++;
            }
            rc.append(c);
        }
            {if ("" != null) return rc.toString();}
    throw new Error("Missing return statement in function");
}

  final public ConfiguredObjectExpression variable() throws ParseException {String s;
    Token t;
    ConfiguredObjectExpression right;
    if (jj_2_7(2)) {
      s = identifier();
      jj_consume_token(45);
      right = variable();
{if ("" != null) return _factory.createConfiguredObjectExpression( s, right );}
    } else if (jj_2_8(2)) {
      s = identifier();
      jj_consume_token(46);
      t = jj_consume_token(DECIMAL_LITERAL);
      jj_consume_token(47);
{if ("" != null) return _factory.createConfiguredObjectExpression( s, Integer.valueOf( t.image ) );}
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ID:
      case QUOTED_ID:{
        s = identifier();
{if ("" != null) return _factory.createConfiguredObjectExpression( s );}
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
}

  final public Expression<E> functionExpression() throws ParseException {String s;
    Token t;
    List<Expression> args = new ArrayList<>();
    Expression<E> expr;
    t = jj_consume_token(FUNCTIONNAME);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case TRUE:
    case FALSE:
    case NULL:
    case DECIMAL_LITERAL:
    case HEX_LITERAL:
    case OCTAL_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case FUNCTIONNAME:
    case ID:
    case QUOTED_ID:
    case 37:
    case 40:
    case 41:{
      expr = addExpression();
args.add(expr);
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case 38:{
          ;
          break;
          }
        default:
          break label_9;
        }
        jj_consume_token(38);
        expr = addExpression();
args.add(expr);
      }
      break;
      }
    default:
      ;
    }
    jj_consume_token(39);
{if ("" != null) return _factory.createFunctionExpression( t.image.substring(0, t.image.length() - 1), args );}
    throw new Error("Missing return statement in function");
}

  final public String identifier() throws ParseException {Token t;
    StringBuffer rc = new StringBuffer();
    String s;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ID:{
      t = jj_consume_token(ID);
s = t.image;
      break;
      }
    case QUOTED_ID:{
      t = jj_consume_token(QUOTED_ID);
// Decode the sting value.
            String image = t.image;
            for( int i=1; i < image.length()-1; i++ ) {
                char c = image.charAt(i);
                if( c == '"' )
                {
                    i++;
                }
                rc.append(c);
            }
            s = rc.toString();
      break;
      }
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return s;}
    throw new Error("Missing return statement in function");
}

  final public List<Map<String, Expression>> selectClause() throws ParseException {List<Map<String, Expression>> returnVal = new ArrayList<>();
    Map<String, Expression> element;
    element = selectClauseElement();
returnVal.add( element );
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 38:{
        ;
        break;
        }
      default:
        break label_10;
      }
      jj_consume_token(38);
      element = selectClauseElement();
returnVal.add( element );
    }
    jj_consume_token(0);
{if ("" != null) return returnVal;}
    throw new Error("Missing return statement in function");
}

  final public Map<String, Expression> selectClauseElement() throws ParseException {String name = null;
    Expression<E> expr;
    expr = addExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      name = identifier();
      break;
      }
    default:
      ;
    }
if(name == null)
          {
              name = ( expr instanceof NamedExpression ) ?  ((NamedExpression) expr).getName() : "";
          }
          {if ("" != null) return Collections.singletonMap( name, expr );}
    throw new Error("Missing return statement in function");
}

  final public List<OrderByExpression<E>> orderByClause() throws ParseException {List<OrderByExpression<E>> returnVal = new ArrayList<>();
    OrderByExpression<E> element;
    element = orderByClauseElement();
returnVal.add( element );
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 38:{
        ;
        break;
        }
      default:
        break label_11;
      }
      jj_consume_token(38);
      element = orderByClauseElement();
returnVal.add( element );
    }
    jj_consume_token(0);
{if ("" != null) return returnVal;}
    throw new Error("Missing return statement in function");
}

  final public OrderByExpression<E> orderByClauseElement() throws ParseException {Expression<E> expr;
    OrderByExpression<E> orderByExpr;
    OrderByExpression.Order order = OrderByExpression.Order.ASC;
    expr = addExpression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASC:
    case DESC:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASC:{
        jj_consume_token(ASC);
        break;
        }
      case DESC:{
        jj_consume_token(DESC);
order = OrderByExpression.Order.DESC;
        break;
        }
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      ;
    }
{if ("" != null) return new OrderByExpression<>(expr, order);}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_3R_comparisonExpression_344_35_67()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_600_5_48()) return true;
    return false;
  }

  private boolean jj_3R_literal_560_9_39()
 {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_multExpr_462_9_24()
 {
    if (jj_scan_token(44)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_656_5_30()
 {
    if (jj_scan_token(FUNCTIONNAME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_functionExpression_657_30_34()) jj_scanpos = xsp;
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_274_5_49()
 {
    if (jj_3R_comparisonExpression_316_5_52()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_equalityExpression_278_13_53()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_stringLiteral_600_5_48()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_353_60_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_comparisonExpression_340_33_64()
 {
    if (jj_scan_token(LIKE)) return true;
    if (jj_3R_stringLiteral_600_5_48()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_344_35_67()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_literal_553_9_38()
 {
    if (jj_scan_token(OCTAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_multExpr_457_9_23()
 {
    if (jj_scan_token(43)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_multExpr_452_9_15()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_multExpr_452_9_22()) {
    jj_scanpos = xsp;
    if (jj_3R_multExpr_457_9_23()) {
    jj_scanpos = xsp;
    if (jj_3R_multExpr_462_9_24()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_multExpr_452_9_22()
 {
    if (jj_scan_token(42)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_andExpression_257_13_50()
 {
    if (jj_scan_token(AND)) return true;
    if (jj_3R_equalityExpression_274_5_49()) return true;
    return false;
  }

  private boolean jj_3R_literal_546_9_37()
 {
    if (jj_scan_token(HEX_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_multExpr_450_5_12()
 {
    if (jj_3R_unaryExpr_480_9_13()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_multExpr_452_9_15()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_variable_639_5_43()
 {
    if (jj_3R_identifier_671_5_14()) return true;
    return false;
  }

  private boolean jj_3R_literal_539_9_36()
 {
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_addExpression_432_17_55()
 {
    if (jj_scan_token(41)) return true;
    if (jj_3R_multExpr_450_5_12()) return true;
    return false;
  }

  private boolean jj_3R_andExpression_254_5_44()
 {
    if (jj_3R_equalityExpression_274_5_49()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_andExpression_257_13_50()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_5()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(40)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    if (jj_3R_multExpr_450_5_12()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_335_17_63()
 {
    if (jj_scan_token(36)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_657_75_47()
 {
    if (jj_scan_token(38)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_literal_532_9_35()
 {
    if (jj_3R_stringLiteral_600_5_48()) return true;
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_3R_identifier_671_5_14()) return true;
    if (jj_scan_token(46)) return true;
    if (jj_scan_token(DECIMAL_LITERAL)) return true;
    if (jj_scan_token(47)) return true;
    return false;
  }

  private boolean jj_3R_addExpression_427_17_54()
 {
    if (jj_scan_token(40)) return true;
    if (jj_3R_multExpr_450_5_12()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_330_17_62()
 {
    if (jj_scan_token(35)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_literal_531_5_31()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_literal_532_9_35()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_539_9_36()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_546_9_37()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_553_9_38()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_560_9_39()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_567_9_40()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_574_9_41()) {
    jj_scanpos = xsp;
    if (jj_3R_literal_581_9_42()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_398_41_70()
 {
    if (jj_scan_token(38)) return true;
    if (jj_3R_primaryExpr_507_5_25()) return true;
    return false;
  }

  private boolean jj_3R_addExpression_425_13_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_addExpression_427_17_54()) {
    jj_scanpos = xsp;
    if (jj_3R_addExpression_432_17_55()) return true;
    }
    return false;
  }

  private boolean jj_3R_orExpression_235_13_45()
 {
    if (jj_scan_token(OR)) return true;
    if (jj_3R_andExpression_254_5_44()) return true;
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_3R_identifier_671_5_14()) return true;
    if (jj_scan_token(45)) return true;
    if (jj_3R_variable_623_5_32()) return true;
    return false;
  }

  private boolean jj_3R_variable_623_5_32()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3R_variable_639_5_43()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_325_17_61()
 {
    if (jj_scan_token(34)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_320_17_60()
 {
    if (jj_scan_token(33)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_320_17_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_comparisonExpression_320_17_60()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_325_17_61()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_330_17_62()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_335_17_63()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_340_33_64()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_358_25_65()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_comparisonExpression_369_33_66()) {
    jj_scanpos = xsp;
    if (jj_3_4()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_addExpression_423_5_46()
 {
    if (jj_3R_multExpr_450_5_12()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_addExpression_425_13_51()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_primaryExpr_514_9_29()
 {
    if (jj_scan_token(37)) return true;
    if (jj_3R_orExpression_232_5_33()) return true;
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3R_orExpression_232_5_33()
 {
    if (jj_3R_andExpression_254_5_44()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_orExpression_235_13_45()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_primaryExpr_512_9_28()
 {
    if (jj_3R_variable_623_5_32()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_510_9_27()
 {
    if (jj_3R_literal_531_5_31()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_508_9_26()
 {
    if (jj_3R_functionExpression_656_5_30()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_377_41_69()
 {
    if (jj_scan_token(38)) return true;
    if (jj_3R_primaryExpr_507_5_25()) return true;
    return false;
  }

  private boolean jj_3R_primaryExpr_507_5_25()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_primaryExpr_508_9_26()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_510_9_27()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_512_9_28()) {
    jj_scanpos = xsp;
    if (jj_3R_primaryExpr_514_9_29()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_comparisonExpression_316_5_52()
 {
    if (jj_3R_addExpression_423_5_46()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_320_17_56()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_stringLiteral_600_5_48()
 {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(37)) return true;
    if (jj_3R_primaryExpr_507_5_25()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_398_41_70()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(40)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_353_60_68()
 {
    if (jj_scan_token(ESCAPE)) return true;
    if (jj_3R_stringLiteral_600_5_48()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_494_13_19()
 {
    if (jj_3R_primaryExpr_507_5_25()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_489_13_18()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_481_17_16()
 {
    if (jj_scan_token(40)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_369_33_66()
 {
    if (jj_scan_token(IN)) return true;
    if (jj_scan_token(37)) return true;
    if (jj_3R_primaryExpr_507_5_25()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_comparisonExpression_377_41_69()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(39)) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_294_13_59()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_484_13_17()
 {
    if (jj_scan_token(41)) return true;
    if (jj_3R_unaryExpr_480_9_13()) return true;
    return false;
  }

  private boolean jj_3R_functionExpression_657_30_34()
 {
    if (jj_3R_addExpression_423_5_46()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_functionExpression_657_75_47()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_identifier_677_9_21()
 {
    if (jj_scan_token(QUOTED_ID)) return true;
    return false;
  }

  private boolean jj_3R_literal_581_9_42()
 {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_identifier_672_9_20()
 {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3R_unaryExpr_480_9_13()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_unaryExpr_481_17_16()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_484_13_17()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_489_13_18()) {
    jj_scanpos = xsp;
    if (jj_3R_unaryExpr_494_13_19()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_literal_574_9_41()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_283_13_58()
 {
    if (jj_scan_token(32)) return true;
    if (jj_3R_comparisonExpression_316_5_52()) return true;
    return false;
  }

  private boolean jj_3R_identifier_671_5_14()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_identifier_672_9_20()) {
    jj_scanpos = xsp;
    if (jj_3R_identifier_677_9_21()) return true;
    }
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_278_13_57()
 {
    if (jj_scan_token(31)) return true;
    if (jj_3R_comparisonExpression_316_5_52()) return true;
    return false;
  }

  private boolean jj_3R_equalityExpression_278_13_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_equalityExpression_278_13_57()) {
    jj_scanpos = xsp;
    if (jj_3R_equalityExpression_283_13_58()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3R_equalityExpression_294_13_59()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_literal_567_9_40()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_comparisonExpression_358_25_65()
 {
    if (jj_scan_token(BETWEEN)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    if (jj_scan_token(AND)) return true;
    if (jj_3R_addExpression_423_5_46()) return true;
    return false;
  }

  /** Generated Token Manager. */
  public ConfiguredObjectFilterParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;

  /** Constructor with InputStream. */
  public ConfiguredObjectFilterParser(java.io.InputStream stream) {
	  this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public ConfiguredObjectFilterParser(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source = new ConfiguredObjectFilterParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
	  ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
	 try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /** Constructor. */
  public ConfiguredObjectFilterParser(java.io.Reader stream) {
	 jj_input_stream = new SimpleCharStream(stream, 1, 1);
	 token_source = new ConfiguredObjectFilterParserTokenManager(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
	if (jj_input_stream == null) {
	   jj_input_stream = new SimpleCharStream(stream, 1, 1);
	} else {
	   jj_input_stream.ReInit(stream, 1, 1);
	}
	if (token_source == null) {
 token_source = new ConfiguredObjectFilterParserTokenManager(jj_input_stream);
	}

	 token_source.ReInit(jj_input_stream);
	 token = new Token();
	 jj_ntk = -1;
  }

  /** Constructor with generated Token Manager. */
  public ConfiguredObjectFilterParser(ConfiguredObjectFilterParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(ConfiguredObjectFilterParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   return token;
	 }
	 token = oldToken;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 Token errortok = token.next;
	 int line = errortok.beginLine, column = errortok.beginColumn;
	 String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
	 return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
