/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.internal;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.Retries;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RootRangeClientImplWithRetries
implements RootRangeClient {
    private static final Logger log = LoggerFactory.getLogger(RootRangeClientImplWithRetries.class);
    @VisibleForTesting
    static final Predicate<Throwable> ROOT_RANGE_CLIENT_RETRY_PREDICATE = cause -> RootRangeClientImplWithRetries.shouldRetryOnException(cause);
    private final RootRangeClient client;
    private final Backoff.Policy backoffPolicy;
    private final OrderedScheduler scheduler;

    private static boolean shouldRetryOnException(Throwable cause) {
        log.error("Reason for the failure ", cause);
        if (cause instanceof StatusRuntimeException || cause instanceof StatusException) {
            Status status = cause instanceof StatusException ? ((StatusException)cause).getStatus() : ((StatusRuntimeException)cause).getStatus();
            switch (status.getCode()) {
                case INVALID_ARGUMENT: 
                case ALREADY_EXISTS: 
                case PERMISSION_DENIED: 
                case UNAUTHENTICATED: {
                    return false;
                }
            }
            return true;
        }
        if (cause instanceof RuntimeException) {
            return false;
        }
        return false;
    }

    RootRangeClientImplWithRetries(RootRangeClient client, Backoff.Policy backoffPolicy, OrderedScheduler scheduler) {
        this.client = client;
        this.backoffPolicy = backoffPolicy;
        this.scheduler = scheduler;
    }

    private <T> CompletableFuture<T> runRpcWithRetries(Supplier<CompletableFuture<T>> futureSupplier) {
        return Retries.run((Stream)this.backoffPolicy.toBackoffs(), ROOT_RANGE_CLIENT_RETRY_PREDICATE, futureSupplier, (OrderedScheduler)this.scheduler);
    }

    @Override
    public CompletableFuture<NamespaceProperties> createNamespace(String namespace, NamespaceConfiguration nsConf) {
        return this.runRpcWithRetries(() -> this.client.createNamespace(namespace, nsConf));
    }

    @Override
    public CompletableFuture<Boolean> deleteNamespace(String namespace) {
        return this.runRpcWithRetries(() -> this.client.deleteNamespace(namespace));
    }

    @Override
    public CompletableFuture<NamespaceProperties> getNamespace(String namespace) {
        return this.runRpcWithRetries(() -> this.client.getNamespace(namespace));
    }

    @Override
    public CompletableFuture<StreamProperties> createStream(String nsName, String streamName, StreamConfiguration streamConf) {
        return this.runRpcWithRetries(() -> this.client.createStream(nsName, streamName, streamConf));
    }

    @Override
    public CompletableFuture<Boolean> deleteStream(String nsName, String streamName) {
        return this.runRpcWithRetries(() -> this.client.deleteStream(nsName, streamName));
    }

    @Override
    public CompletableFuture<StreamProperties> getStream(String nsName, String streamName) {
        return this.runRpcWithRetries(() -> this.client.getStream(nsName, streamName));
    }

    @Override
    public CompletableFuture<StreamProperties> getStream(long streamId) {
        return this.runRpcWithRetries(() -> this.client.getStream(streamId));
    }
}

