/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.TestRollLogSegments;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTxnId
extends TestDistributedLogBase {
    private static final Logger logger = LoggerFactory.getLogger(TestRollLogSegments.class);

    @Test
    public void testRecoveryAfterBookieCrash() throws Exception {
        Throwable throwable;
        BKAsyncLogWriter writer2;
        Throwable throwable2;
        BKDistributedLogManager dlm2;
        String name = "txnid-after-crash";
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setEnsembleSize(5).setWriteQuorumSize(5).setAckQuorumSize(5).setLogSegmentRollingIntervalMinutes(0).setLogSegmentRollingConcurrency(-1).setMaxLogSegmentBytes(400000L);
        bkutil.addBookie();
        bkutil.addBookie();
        try {
            dlm2 = this.createNewDLM(conf, name);
            throwable2 = null;
            try {
                writer2 = dlm2.startAsyncLogSegmentNonPartitioned();
                throwable = null;
                try {
                    writer2.write(DLMTestUtil.getLogRecordInstance(1L, 100000)).join();
                    writer2.write(DLMTestUtil.getLogRecordInstance(2L, 100000)).join();
                    bkutil.removeBookie();
                    bkutil.removeBookie();
                    try {
                        writer2.write(DLMTestUtil.getLogRecordInstance(3L, 100000)).join();
                        Assert.fail((String)"Shouldn't have succeeded");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    writer2.write(DLMTestUtil.getLogRecordInstance(4L, 100000)).join();
                    Assert.fail((String)"Shouldn't be able to write");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (writer2 != null) {
                        if (throwable != null) {
                            try {
                                writer2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            writer2.close();
                        }
                    }
                }
            }
            catch (Throwable writer2) {
                throwable2 = writer2;
                throw writer2;
            }
            finally {
                if (dlm2 != null) {
                    if (throwable2 != null) {
                        try {
                            dlm2.close();
                        }
                        catch (Throwable writer2) {
                            throwable2.addSuppressed(writer2);
                        }
                    } else {
                        dlm2.close();
                    }
                }
            }
        }
        catch (Exception dlm2) {
            // empty catch block
        }
        bkutil.addBookie();
        bkutil.addBookie();
        dlm2 = this.createNewDLM(conf, name);
        throwable2 = null;
        try {
            writer2 = dlm2.startAsyncLogSegmentNonPartitioned();
            throwable = null;
            try {
                long firstTxid = dlm2.getLastTxId() + 1L;
                for (int i = 0; i < 20; ++i) {
                    logger.info("Writing entry {}", (Object)i);
                    writer2.write(DLMTestUtil.getLogRecordInstance(firstTxid + (long)i, 100000)).join();
                    Thread.sleep(100L);
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (writer2 != null) {
                    if (throwable != null) {
                        try {
                            writer2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        writer2.close();
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            throwable2 = throwable7;
            throw throwable7;
        }
        finally {
            if (dlm2 != null) {
                if (throwable2 != null) {
                    try {
                        dlm2.close();
                    }
                    catch (Throwable throwable8) {
                        throwable2.addSuppressed(throwable8);
                    }
                } else {
                    dlm2.close();
                }
            }
        }
    }
}

