/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.nonpersistent;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.service.AbstractDispatcherSingleActiveConsumer;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.RedeliveryTrackerDisabled;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentDispatcher;
import org.apache.pulsar.broker.service.nonpersistent.NonPersistentTopic;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.Rate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonPersistentDispatcherSingleActiveConsumer
extends AbstractDispatcherSingleActiveConsumer
implements NonPersistentDispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NonPersistentDispatcherSingleActiveConsumer.class);
    private final NonPersistentTopic topic;
    private final Rate msgDrop;
    protected final String name;
    private final Subscription subscription;
    private final RedeliveryTracker redeliveryTracker;

    public NonPersistentDispatcherSingleActiveConsumer(CommandSubscribe.SubType subscriptionType, int partitionIndex, NonPersistentTopic topic, Subscription subscription) {
        super(subscriptionType, partitionIndex, topic.getName(), subscription, topic.getBrokerService().pulsar().getConfiguration(), null);
        this.topic = topic;
        this.subscription = subscription;
        this.name = topic.getName() + " / " + subscription.getName();
        this.msgDrop = new Rate();
        this.redeliveryTracker = RedeliveryTrackerDisabled.REDELIVERY_TRACKER_DISABLED;
    }

    @Override
    public synchronized void sendMessages(List<Entry> entries) {
        Consumer currentConsumer = this.getActiveConsumer();
        if (currentConsumer != null && currentConsumer.getAvailablePermits() > 0 && currentConsumer.isWritable()) {
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entries.size());
            this.filterEntriesForConsumer(entries, batchSizes, sendMessageInfo, null, null, false, currentConsumer);
            currentConsumer.sendMessages(entries, batchSizes, null, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker());
        } else {
            entries.forEach(entry -> {
                int totalMsgs = Commands.getNumberOfMessagesInBatch((ByteBuf)entry.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
                if (totalMsgs > 0) {
                    this.msgDrop.recordEvent((long)totalMsgs);
                }
                entry.release();
            });
        }
    }

    @Override
    protected boolean isConsumersExceededOnSubscription() {
        return this.isConsumersExceededOnSubscription(this.topic, this.consumers.size());
    }

    @Override
    public Rate getMessageDropRate() {
        return this.msgDrop;
    }

    @Override
    public boolean hasPermits() {
        return this.getActiveConsumer() != null && this.getActiveConsumer().getAvailablePermits() > 0;
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
    }

    @Override
    public RedeliveryTracker getRedeliveryTracker() {
        return this.redeliveryTracker;
    }

    @Override
    protected void scheduleReadOnActiveConsumer() {
    }

    @Override
    protected void cancelPendingRead() {
    }

    @Override
    protected void reScheduleRead() {
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

