/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.pbx.agi;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.asteriskjava.fastagi.AgiChannel;
import org.asteriskjava.fastagi.AgiException;
import org.asteriskjava.fastagi.AgiHangupException;
import org.asteriskjava.pbx.AgiChannelActivityAction;
import org.asteriskjava.pbx.Channel;
import org.asteriskjava.pbx.agi.ActivityAgi;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class AgiChannelActivityHold
implements AgiChannelActivityAction {
    private final Log logger = LogFactory.getLog(this.getClass());
    CountDownLatch latch = new CountDownLatch(1);
    volatile boolean callReachedAgi = false;
    long timer = System.currentTimeMillis();

    @Override
    public void execute(AgiChannel channel, Channel ichannel) throws AgiException, InterruptedException {
        try {
            this.callReachedAgi = true;
            channel.answer();
            channel.playMusicOnHold();
            long secondsOnHold = Math.abs(System.currentTimeMillis() - this.timer) / 1000L;
            if (secondsOnHold > 600L) {
                this.logger.info(ichannel + " is still on hold after " + secondsOnHold + " seconds");
            }
            if (this.latch.await(10L, TimeUnit.SECONDS)) {
                try {
                    channel.stopMusicOnHold();
                }
                catch (AgiHangupException e) {
                    this.logger.info("Channel hungup " + channel.getName());
                }
                catch (Exception e) {
                    this.logger.warn(e);
                }
            } else if (channel.getName().startsWith("Local") && secondsOnHold > 3600L) {
                this.logger.error("Hanging up local channel that has been on hold for 1 hour " + channel.getName());
                channel.hangup();
            }
        }
        catch (AgiHangupException e) {
            this.logger.warn(e);
        }
    }

    @Override
    public boolean isDisconnect(ActivityAgi activityAgi) {
        return false;
    }

    @Override
    public void cancel() {
        this.latch.countDown();
    }

    public boolean hasCallReachedAgi() {
        return this.callReachedAgi;
    }
}

