/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.registry;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.nifi.RegistryFlowVersionsResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.entity.VersionedFlowSnapshotMetadataSetEntity;

public class ListFlowVersions
extends AbstractNiFiCommand<RegistryFlowVersionsResult> {
    public ListFlowVersions() {
        super("list-flow-versions", RegistryFlowVersionsResult.class);
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.REGISTRY_CLIENT_ID.createOption());
        this.addOption(CommandOption.FLOW_BRANCH.createOption());
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.FLOW_ID.createOption());
    }

    @Override
    public String getDescription() {
        return "Returns the list of flow versions for a given flow in a given branch and bucket seen by the specified registry client.";
    }

    @Override
    public RegistryFlowVersionsResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String regClientId = this.getRequiredArg(properties, CommandOption.REGISTRY_CLIENT_ID);
        String branchName = this.getRequiredArg(properties, CommandOption.FLOW_BRANCH);
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        String flowId = this.getRequiredArg(properties, CommandOption.FLOW_ID);
        VersionedFlowSnapshotMetadataSetEntity flowVersions = client.getFlowClient().getVersions(regClientId, bucketId, flowId, branchName);
        return new RegistryFlowVersionsResult(this.getResultType(properties), flowVersions);
    }
}

