/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authorization.method;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.authorization.method.AbstractExpressionAttributeRegistry;
import org.springframework.security.authorization.method.ExpressionAttribute;
import org.springframework.security.authorization.method.HandleAuthorizationDenied;
import org.springframework.security.authorization.method.MethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.PostAuthorizeAuthorizationManager;
import org.springframework.security.authorization.method.PostAuthorizeExpressionAttribute;
import org.springframework.security.authorization.method.ReflectiveMethodAuthorizationDeniedHandler;
import org.springframework.security.authorization.method.ThrowingMethodAuthorizationDeniedHandler;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.annotation.SecurityAnnotationScanner;
import org.springframework.security.core.annotation.SecurityAnnotationScanners;
import org.springframework.util.Assert;
import reactor.util.annotation.NonNull;

final class PostAuthorizeExpressionAttributeRegistry
extends AbstractExpressionAttributeRegistry<ExpressionAttribute> {
    private final MethodAuthorizationDeniedHandler defaultHandler = new ThrowingMethodAuthorizationDeniedHandler();
    private final SecurityAnnotationScanner<HandleAuthorizationDenied> handleAuthorizationDeniedScanner = SecurityAnnotationScanners.requireUnique(HandleAuthorizationDenied.class);
    private Function<Class<? extends MethodAuthorizationDeniedHandler>, MethodAuthorizationDeniedHandler> handlerResolver;
    private SecurityAnnotationScanner<PostAuthorize> postAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PostAuthorize.class);

    PostAuthorizeExpressionAttributeRegistry() {
        this.handlerResolver = clazz -> new ReflectiveMethodAuthorizationDeniedHandler((Class<?>)clazz, PostAuthorizeAuthorizationManager.class);
    }

    @Override
    @NonNull
    ExpressionAttribute resolveAttribute(Method method, Class<?> targetClass) {
        PostAuthorize postAuthorize = this.findPostAuthorizeAnnotation(method, targetClass);
        if (postAuthorize == null) {
            return ExpressionAttribute.NULL_ATTRIBUTE;
        }
        Expression expression = this.getExpressionHandler().getExpressionParser().parseExpression(postAuthorize.value());
        MethodAuthorizationDeniedHandler deniedHandler = this.resolveHandler(method, targetClass);
        return new PostAuthorizeExpressionAttribute(expression, deniedHandler);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        HandleAuthorizationDenied deniedHandler = this.handleAuthorizationDeniedScanner.scan(method, targetClassToUse);
        if (deniedHandler != null) {
            return this.handlerResolver.apply(deniedHandler.handlerClass());
        }
        return this.defaultHandler;
    }

    private PostAuthorize findPostAuthorizeAnnotation(Method method, Class<?> targetClass) {
        Class<?> targetClassToUse = this.targetClass(method, targetClass);
        return this.postAuthorizeScanner.scan(method, targetClassToUse);
    }

    void setApplicationContext(ApplicationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        this.handlerResolver = clazz -> this.resolveHandler(context, (Class<? extends MethodAuthorizationDeniedHandler>)clazz);
    }

    @Override
    void setTemplateDefaults(AnnotationTemplateExpressionDefaults templateDefaults) {
        this.postAuthorizeScanner = SecurityAnnotationScanners.requireUnique(PostAuthorize.class, templateDefaults);
    }

    private MethodAuthorizationDeniedHandler resolveHandler(ApplicationContext context, Class<? extends MethodAuthorizationDeniedHandler> handlerClass) {
        if (handlerClass == this.defaultHandler.getClass()) {
            return this.defaultHandler;
        }
        Object[] beanNames = context.getBeanNamesForType(handlerClass);
        if (beanNames.length == 0) {
            throw new IllegalStateException("Could not find a bean of type " + handlerClass.getName());
        }
        if (beanNames.length > 1) {
            throw new IllegalStateException("Expected to find a single bean of type " + handlerClass.getName() + " but found " + Arrays.toString(beanNames));
        }
        return (MethodAuthorizationDeniedHandler)context.getBean(beanNames[0], handlerClass);
    }
}

