/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.iso23001.part7;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.mp4parser.MemoryAllocationException;
import org.mp4parser.aj.lang.JoinPoint;
import org.mp4parser.aj.lang.Signature;
import org.mp4parser.aj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.CastUtils;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.IsoTypeWriter;
import org.mp4parser.tools.MemoryUtils;
import org.mp4parser.tools.UUIDConverter;

public class ProtectionSystemSpecificHeaderBox
extends AbstractFullBox {
    private static final long MAX_RECORD_LENGTH = 1000000L;
    private static final int MAX_RECORDS = 100000;
    public static final String TYPE = "pssh";
    public static byte[] OMA2_SYSTEM_ID;
    public static byte[] WIDEVINE;
    public static byte[] PLAYREADY_SYSTEM_ID;
    byte[] content;
    byte[] systemId;
    List<UUID> keyIds = new ArrayList<UUID>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        ProtectionSystemSpecificHeaderBox.ajc$preClinit();
        OMA2_SYSTEM_ID = UUIDConverter.convert(UUID.fromString("A2B55680-6F43-11E0-9A3F-0002A5D5C51B"));
        WIDEVINE = UUIDConverter.convert(UUID.fromString("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed"));
        PLAYREADY_SYSTEM_ID = UUIDConverter.convert(UUID.fromString("9A04F079-9840-4286-AB92-E65BE0885F95"));
    }

    public ProtectionSystemSpecificHeaderBox(byte[] systemId, byte[] content) {
        super(TYPE);
        this.content = content;
        this.systemId = systemId;
    }

    public ProtectionSystemSpecificHeaderBox() {
        super(TYPE);
    }

    public List<UUID> getKeyIds() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.keyIds;
    }

    public void setKeyIds(List<UUID> keyIds) {
        List<UUID> list = keyIds;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, list);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.keyIds = keyIds;
    }

    public byte[] getSystemId() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_2, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.systemId;
    }

    public void setSystemId(byte[] systemId) {
        byte[] byArray = systemId;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_3, (Object)this, (Object)this, (Object)byArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        assert (systemId.length == 16);
        this.systemId = systemId;
    }

    public byte[] getContent() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_4, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.content;
    }

    public void setContent(byte[] content) {
        byte[] byArray = content;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_5, (Object)this, (Object)this, (Object)byArray);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.content = content;
    }

    @Override
    protected long getContentSize() {
        long l = 24 + this.content.length;
        if (this.getVersion() > 0) {
            l += 4L;
            l += (long)(16 * this.keyIds.size());
        }
        return l;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        assert (this.systemId.length == 16);
        byteBuffer.put(this.systemId, 0, 16);
        if (this.getVersion() > 0) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.keyIds.size());
            for (UUID keyId : this.keyIds) {
                byteBuffer.put(UUIDConverter.convert(keyId));
            }
        }
        IsoTypeWriter.writeUInt32(byteBuffer, this.content.length);
        byteBuffer.put(this.content);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _parseDetails(ByteBuffer content) {
        block2: {
            this.parseVersionAndFlags(content);
            this.systemId = new byte[16];
            content.get(this.systemId);
            if (this.getVersion() <= 0) break block2;
            count = CastUtils.l2i(IsoTypeReader.readUInt32(content));
            if (count <= 100000) ** GOTO lbl15
            throw new MemoryAllocationException("Limit on record count reached: " + count);
lbl-1000:
            // 1 sources

            {
                k = new byte[16];
                content.get(k);
                this.keyIds.add(UUIDConverter.convert(k));
lbl15:
                // 2 sources

                ** while (count-- > 0)
            }
        }
        length = IsoTypeReader.readUInt32(content);
        this.content = MemoryUtils.allocateByteArray(content.remaining(), 1000000L);
        content.get(this.content);
        if (!ProtectionSystemSpecificHeaderBox.$assertionsDisabled && length != (long)this.content.length) {
            throw new AssertionError();
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProtectionSystemSpecificHeaderBox.java", ProtectionSystemSpecificHeaderBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getKeyIds", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "", "", "", "java.util.List"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setKeyIds", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "java.util.List", "keyIds", "", "void"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSystemId", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "", "", "", "[B"), 64);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setSystemId", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "[B", "systemId", "", "void"), 68);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getContent", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "", "", "", "[B"), 73);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setContent", "org.mp4parser.boxes.iso23001.part7.ProtectionSystemSpecificHeaderBox", "[B", "content", "", "void"), 77);
    }
}

