/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class ContainerResponseContextImpl
implements ContainerResponseContext {
    protected final HttpRequest request;
    protected final HttpResponse httpResponse;
    protected final BuiltResponse jaxrsResponse;

    public ContainerResponseContextImpl(HttpRequest request, HttpResponse httpResponse, BuiltResponse serverResponse) {
        this.request = request;
        this.httpResponse = httpResponse;
        this.jaxrsResponse = serverResponse;
    }

    public BuiltResponse getJaxrsResponse() {
        return this.jaxrsResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatus() {
        return this.jaxrsResponse.getStatus();
    }

    public void setStatus(int code) {
        this.httpResponse.setStatus(code);
        this.jaxrsResponse.setStatus(code);
    }

    public Response.StatusType getStatusInfo() {
        return this.jaxrsResponse.getStatusInfo();
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.httpResponse.setStatus(statusInfo.getStatusCode());
        this.jaxrsResponse.setStatus(statusInfo.getStatusCode());
    }

    public Class<?> getEntityClass() {
        return this.jaxrsResponse.getEntityClass();
    }

    public Type getEntityType() {
        return this.jaxrsResponse.getGenericType();
    }

    public void setEntity(Object entity) {
        this.jaxrsResponse.setEntity(entity);
        this.getHeaders().remove((Object)"Content-Length");
    }

    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.jaxrsResponse.setEntity(entity);
        this.jaxrsResponse.setAnnotations(annotations);
        this.jaxrsResponse.getHeaders().putSingle((Object)"Content-Type", (Object)mediaType);
        this.getHeaders().remove((Object)"Content-Length");
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.jaxrsResponse.getMetadata();
    }

    public Set<String> getAllowedMethods() {
        return this.jaxrsResponse.getAllowedMethods();
    }

    public Date getDate() {
        return this.jaxrsResponse.getDate();
    }

    public Locale getLanguage() {
        return this.jaxrsResponse.getLanguage();
    }

    public int getLength() {
        return this.jaxrsResponse.getLength();
    }

    public MediaType getMediaType() {
        return this.jaxrsResponse.getMediaType();
    }

    public Map<String, NewCookie> getCookies() {
        return this.jaxrsResponse.getCookies();
    }

    public EntityTag getEntityTag() {
        return this.jaxrsResponse.getEntityTag();
    }

    public Date getLastModified() {
        return this.jaxrsResponse.getLastModified();
    }

    public URI getLocation() {
        return this.jaxrsResponse.getLocation();
    }

    public Set<Link> getLinks() {
        return this.jaxrsResponse.getLinks();
    }

    public boolean hasLink(String relation) {
        return this.jaxrsResponse.hasLink(relation);
    }

    public Link getLink(String relation) {
        return this.jaxrsResponse.getLink(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        return this.jaxrsResponse.getLinkBuilder(relation);
    }

    public boolean hasEntity() {
        return this.jaxrsResponse.hasEntity();
    }

    public Object getEntity() {
        return this.jaxrsResponse.getEntity();
    }

    public OutputStream getEntityStream() {
        try {
            return this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setEntityStream(OutputStream entityStream) {
        this.httpResponse.setOutputStream(entityStream);
    }

    public Annotation[] getEntityAnnotations() {
        return this.jaxrsResponse.getAnnotations();
    }

    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxrsResponse.getStringHeaders();
    }

    public String getHeaderString(String name) {
        return this.jaxrsResponse.getHeaderString(name);
    }
}

