/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.edal.time;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.field.PreciseDurationDateTimeField;
import uk.ac.rdg.resc.edal.time.FixedYearVariableMonthChronology;

final class DayOfMonthOfFixedYearDateTimeField
extends PreciseDurationDateTimeField {
    private final FixedYearVariableMonthChronology chron;
    private final int[] daysInMonth;
    private int maxValue;

    public DayOfMonthOfFixedYearDateTimeField(FixedYearVariableMonthChronology chron) {
        super(DateTimeFieldType.dayOfMonth(), chron.days());
        this.chron = chron;
        this.daysInMonth = chron.getMonthLengths();
        this.maxValue = this.daysInMonth[0];
        for (int i = 1; i < this.daysInMonth.length; ++i) {
            this.maxValue = Math.max(this.maxValue, this.daysInMonth[i]);
        }
    }

    public int get(long instant) {
        int dayOfYear = this.chron.dayOfYear().get(instant);
        int monthOfYear = this.chron.monthOfYear().get(instant);
        int numCompletedMonths = monthOfYear - 1;
        int daysInCompletedMonths = 0;
        for (int i = 0; i < numCompletedMonths; ++i) {
            daysInCompletedMonths += this.daysInMonth[i];
        }
        return dayOfYear - daysInCompletedMonths;
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return this.maxValue;
    }

    public int getMaximumValue(long instant) {
        int monthOfYear = this.chron.monthOfYear().get(instant);
        return this.daysInMonth[monthOfYear - 1];
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.monthOfYear())) {
            int month = partial.get(DateTimeFieldType.monthOfYear());
            return this.daysInMonth[month - 1];
        }
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        for (int i = 0; i < size; ++i) {
            if (partial.getFieldType(i) != DateTimeFieldType.monthOfYear()) continue;
            int month = values[i];
            return this.daysInMonth[month - 1];
        }
        return this.getMaximumValue();
    }

    public DurationField getRangeDurationField() {
        return this.chron.months();
    }
}

